<?php

declare(strict_types=1);

namespace NewSite\Util;

/**
 * URL slug generator utility.
 *
 * Security notes:
 * - Only allows lowercase alphanumeric characters and hyphens in output,
 *   stripping all special characters to prevent injection via URL segments.
 * - No inline JavaScript or inline styles are emitted (strict CSP compliance).
 */
final class SlugGenerator
{
    /**
     * Generate a URL-safe slug from a title string.
     *
     * @param string $title The human-readable title to slugify.
     * @return string A lowercase, hyphen-separated slug safe for use in URLs.
     */
    public static function generate(string $title): string
    {
        $slug = strtolower(trim($title));
        $slug = preg_replace('/[^a-z0-9-]/', '-', $slug);
        $slug = preg_replace('/-+/', '-', $slug);
        return trim($slug, '-');
    }
}
