<?php

declare(strict_types=1);

namespace NewSite\Util;

/**
 * Static currency symbol mapping.
 *
 * Security notes:
 * - All data is hard-coded; no user input is interpolated.
 * - Currency symbols contain Unicode characters — callers must ensure
 *   the output encoding is UTF-8 when rendering in HTML.
 * - No inline JavaScript or inline styles are emitted (strict CSP compliance).
 */
final class CurrencyData
{
    /**
     * Return a map of ISO 4217 currency codes to their display symbols.
     *
     * @return array<string, string>
     */
    public static function getMap(): array
    {
        return [
            'USD' => '$',
            'EUR' => '€',
            'GBP' => '£',
            'JPY' => '¥',
            'AUD' => 'A$',
            'CAD' => 'C$',
            'CHF' => 'CHF',
            'SEK' => 'SEK',
            'NOK' => 'NOK',
            'DKK' => 'DKK',
            'PLN' => 'PLN',
            'BRL' => 'R$',
            'MXN' => 'MX$',
            'INR' => '₹',
            'KRW' => '₩',
            'CNY' => '¥'
        ];
    }
}
