<?php

declare(strict_types=1);

namespace NewSite\Http;

/**
 * StripeClient — lightweight cURL wrapper for the Stripe REST API.
 *
 * Security: the API secret is transmitted exclusively via the
 * Authorization header over HTTPS. No credentials are logged or
 * included in response payloads.
 */
final class StripeClient
{
    public static function request(string $method, string $endpoint, array $params, string $secret): array
    {
        $url = 'https://api.stripe.com' . $endpoint;
        $method = strtoupper($method);
        $ch = curl_init();
        if ($method === 'GET' && !empty($params)) {
            $url .= (strpos($url, '?') === false ? '?' : '&') . http_build_query($params);
        }
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Authorization: Bearer ' . $secret]);
        if ($method === 'POST') {
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));
        }
        $response = curl_exec($ch);
        $status = (int)curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $error = curl_error($ch);
        // CurlHandle auto-closes on scope exit (PHP 8.0+)
        $data = [];
        if ($response !== false && $response !== '') {
            $decoded = json_decode($response, true);
            if (is_array($decoded)) {
                $data = $decoded;
            }
        }
        return ['status' => $status, 'data' => $data, 'error' => $error];
    }
}
