<?php

declare(strict_types=1);

namespace NewSite\Database;

use NewSite\Database\DatabaseManager;

/**
 * Database helper utilities for common query operations.
 *
 * Security: All queries use prepared statements via PDO to prevent SQL injection.
 * Callers must pass parameterized SQL; raw user input must never be concatenated.
 */
final class DbHelper
{
    public static function nowString(): string
    {
        return date('Y-m-d H:i:s');
    }

    public static function lastInsertId(\PDO $db, string $table = ''): int
    {
        if ($table !== '') {
            return (int)$db->lastInsertId($table . '_id_seq');
        }
        return (int)$db->lastInsertId();
    }

    public static function querySingle(string $sql, array $params = []): ?array
    {
        $db = DatabaseManager::getReadConnection();
        $stmt = $db->prepare($sql);
        $stmt->execute($params);
        $row = $stmt->fetch(\PDO::FETCH_ASSOC);
        return $row ?: null;
    }

    public static function initDatabase(): void
    {
        $manager = new \NewSite\Database\SchemaManager(DatabaseManager::getWriteConnection());
        $manager->run();
    }
}
