<?php

declare(strict_types=1);

namespace NewSite\Contact;

use NewSite\Database\DatabaseManager;
use NewSite\Security\IpService;
use NewSite\Settings\SettingsService;

/**
 * Contact-form service.
 *
 * Security: All database access uses prepared statements with bound parameters.
 * IP addresses are stored through IpService::gdprStore() for GDPR compliance.
 */
final class ContactService
{
    public static function isEnabled(): bool
    {
        return SettingsService::get('contact_enabled', '1') === '1';
    }

    public static function getEmail(): string
    {
        return SettingsService::get('contact_email', '') ?? '';
    }

    public static function saveMessage(
        string $name,
        string $email,
        string $subject,
        string $message,
        string $ip,
        string $userAgent,
        string $referrer,
    ): bool {
        $db = DatabaseManager::getWriteConnection();
        $storedIp = IpService::gdprStore($ip);

        $stmt = $db->prepare(
            "INSERT INTO contact_messages
                (name, email, subject, message, ip_address, user_agent, referrer)
             VALUES (?, ?, ?, ?, ?, ?, ?)"
        );
        return $stmt->execute([$name, $email, $subject, $message, $storedIp, $userAgent, $referrer]);
    }
}
