<?php
use NewSite\Cleanup\MissingUploadsService;

$title = trim($sectionSettings['title'] ?? '');
$content = $sectionSettings['content'] ?? '';
$cleanContent = MissingUploadsService::stripFromHtml($content);
$allowedAlignments = ['left', 'center', 'right'];
$titleAlign = in_array($sectionSettings['title_align'] ?? 'left', $allowedAlignments, true) ? ($sectionSettings['title_align'] ?? 'left') : 'left';
$textAlign = in_array($sectionSettings['text_align'] ?? 'left', $allowedAlignments, true) ? ($sectionSettings['text_align'] ?? 'left') : 'left';
$titleSize = (int)($sectionSettings['title_size'] ?? 32);
$textSize = (int)($sectionSettings['text_size'] ?? 16);
$titleSize = max(18, min(64, $titleSize));
$textSize = max(12, min(28, $textSize));

$renderContent = $cleanContent;
if (strpos($cleanContent, '<') === false) {
    $lines = preg_split('/\r\n|\r|\n/', trim($cleanContent));
    $paragraphs = [];
    foreach ($lines as $line) {
        $line = trim($line);
        if ($line === '') {
            continue;
        }
        $paragraphs[] = '<p>' . e($line) . '</p>';
    }
    $renderContent = implode("\n", $paragraphs);
}
?>
<section class="section-text-box">
    <div class="container">
        <div class="text-box-card">
            <?php if ($title !== ''): ?>
                <h2 class="text-align-<?php echo e($titleAlign); ?> font-size-<?php echo $titleSize; ?>">
                    <?php echo e($title); ?>
                </h2>
            <?php endif; ?>
            <div class="text-box-content text-align-<?php echo e($textAlign); ?> font-size-<?php echo $textSize; ?>">
                <?php echo $renderContent; ?>
            </div>
        </div>
    </div>
</section>
