<?php
$sectionTitle = trim($sectionSettings['section_title'] ?? '');
$testimonials = $sectionSettings['testimonials'] ?? [];
$cardWidth = (int)($sectionSettings['card_width'] ?? 320);
$cardWidth = max(220, min(520, $cardWidth));
$autoScroll = isset($sectionSettings['auto_scroll']) ? (bool)$sectionSettings['auto_scroll'] : true;
$autoInterval = (int)($sectionSettings['auto_interval'] ?? 5);
$autoInterval = max(2, min(20, $autoInterval));
$sectionId = (int)($section['id'] ?? 0);
$sectionClass = $sectionId > 0 ? 'section-id-' . $sectionId : '';
?>
<section class="section-testimonials <?php echo e($sectionClass); ?>">
    <div class="container">
        <?php if ($sectionTitle !== ''): ?>
            <div class="testimonials-header">
                <h2><?php echo e($sectionTitle); ?></h2>
            </div>
        <?php endif; ?>
        <div class="testimonials-track" data-card-width="<?php echo $cardWidth; ?>" data-auto="<?php echo $autoScroll ? '1' : '0'; ?>" data-interval="<?php echo $autoInterval; ?>">
            <?php foreach ($testimonials as $testimonial):
                $title = trim($testimonial['title'] ?? '');
                $author = trim($testimonial['author'] ?? '');
                $comment = trim($testimonial['comment'] ?? '');
                $stars = (int)($testimonial['stars'] ?? 5);
                $stars = max(1, min(5, $stars));
            ?>
            <div class="testimonial-card">
                <div class="testimonial-stars">
                    <?php for ($i = 0; $i < $stars; $i++): ?>
                        <span>★</span>
                    <?php endfor; ?>
                </div>
                <?php if ($title !== ''): ?>
                    <h3 class="testimonial-title"><?php echo e($title); ?></h3>
                <?php endif; ?>
                <?php if ($comment !== ''): ?>
                    <p class="testimonial-comment"><?php echo e($comment); ?></p>
                <?php endif; ?>
                <?php if ($author !== ''): ?>
                    <div class="testimonial-author">— <?php echo e($author); ?></div>
                <?php endif; ?>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>
