<?php
/**
 * Split Slideshow Section Template
 */

$slides = $sectionSettings['slides'] ?? [];
$autoplay = $sectionSettings['autoplay'] ?? true;
$showArrows = $sectionSettings['show_arrows'] ?? true;
$showDots = $sectionSettings['show_dots'] ?? true;
$sectionId = (int)($section['id'] ?? 0);
$sectionClass = $sectionId > 0 ? 'section-id-' . $sectionId : '';

if (!function_exists('extractYouTubeIdFromUrl')) {
    function extractYouTubeIdFromUrl(string $url): string {
        $url = trim($url);
        if ($url === '') {
            return '';
        }
        $patterns = [
            '~youtu\.be/([A-Za-z0-9_-]{11})~',
            '~youtube\.com/(?:watch\?v=|embed/|shorts/)([A-Za-z0-9_-]{11})~',
            '~[?&]v=([A-Za-z0-9_-]{11})~',
            '~^([A-Za-z0-9_-]{11})$~'
        ];

        $videoId = '';
        foreach ($patterns as $pattern) {
            if (preg_match($pattern, $url, $match)) {
                $videoId = $match[1] ?? '';
                break;
            }
        }

        return $videoId;
    }
}

if (empty($slides)) {
    // Default demo slides
    $slides = [
        [
            'title' => 'Welcome to Your Website',
            'description' => 'Create stunning websites with our powerful theme builder. Customize everything to match your brand.',
            'button_text' => 'Get Started',
            'button_link_type' => 'custom',
            'button_url' => '#',
            'button_product_id' => '',
            'media_source' => 'manual',
            'image' => '/assets/images/placeholder-1.svg'
        ],
        [
            'title' => 'Beautiful & Modern',
            'description' => 'Our neon-inspired design brings your content to life with vibrant colors and smooth animations.',
            'button_text' => 'Learn More',
            'button_link_type' => 'custom',
            'button_url' => '#',
            'button_product_id' => '',
            'media_source' => 'manual',
            'image' => '/assets/images/placeholder-2.svg'
        ]
    ];
}

$productById = [];
$productIds = [];
foreach ($slides as $slide) {
    $slideProductId = (int)($slide['button_product_id'] ?? 0);
    $slideLinkType = $slide['button_link_type'] ?? 'custom';
    $slideMediaSource = $slide['media_source'] ?? 'manual';
    if ($slideProductId > 0 && ($slideLinkType === 'product' || $slideMediaSource === 'product')) {
        $productIds[$slideProductId] = true;
    }
}

if (!empty($productIds) && isset($db)) {
    $ids = array_keys($productIds);
    $placeholders = implode(',', array_fill(0, count($ids), '?'));
    $stmt = $db->prepare("SELECT p.id, p.product_slug, p.media_url, p.action_type, p.download_url, pg.slug AS page_slug, pm.media_url AS gallery_media FROM products p LEFT JOIN pages pg ON pg.id = p.page_id LEFT JOIN product_media pm ON pm.product_id = p.id AND pm.sort_order = 0 WHERE p.id IN ($placeholders) AND p.is_active = 1");
    $stmt->execute($ids);
    foreach ($stmt->fetchAll() as $row) {
        $pid = (int)($row['id'] ?? 0);
        if ($pid > 0) {
            $productById[$pid] = $row;
        }
    }
}

$videoMetaByPath = [];
?>
<section class="section-split-slideshow <?php echo e($sectionClass); ?>" data-autoplay="<?php echo $autoplay ? 'true' : 'false'; ?>">
    <?php foreach ($slides as $index => $slide):
        $slideLinkType = $slide['button_link_type'] ?? 'custom';
        $slideMediaSource = $slide['media_source'] ?? 'manual';
        $slideProductId = (int)($slide['button_product_id'] ?? 0);
        $buttonText = trim((string)($slide['button_text'] ?? ''));
        $buttonUrl = '';
        $buttonTarget = '';
        $buttonRel = '';

        if ($slideLinkType === 'product' && $slideProductId > 0 && isset($productById[$slideProductId])) {
            $product = $productById[$slideProductId];
            $pageSlug = trim($product['page_slug'] ?? '');
            $productSlug = trim((string)($product['product_slug'] ?? ''));
            if ($pageSlug !== '' && $productSlug !== '') {
                $buttonUrl = '/' . $pageSlug . '/' . rawurlencode($productSlug);
            } else {
                $buttonUrl = $pageSlug !== '' ? '/' . $pageSlug . '?product=' . $slideProductId : '/product?product=' . $slideProductId;
            }
            $buttonTarget = '';
            $buttonRel = '';
        }

        if ($buttonUrl === '') {
            $customUrlRaw = trim((string)($slide['button_url'] ?? ''));
            if (
                $customUrlRaw !== ''
                && (
                    strpos($customUrlRaw, '/') === 0
                    || strpos($customUrlRaw, '#') === 0
                    || preg_match('#^https://#i', $customUrlRaw)
                )
            ) {
                $buttonUrl = $customUrlRaw;
            }
        }

        // Get the media path directly
        $media = $slide['image'] ?? '';
        if ($slideMediaSource === 'product' && $slideProductId > 0 && isset($productById[$slideProductId])) {
            $productMedia = trim((string)($productById[$slideProductId]['gallery_media'] ?? $productById[$slideProductId]['media_url'] ?? ''));
            if ($productMedia !== '') {
                $media = $productMedia;
            }
        }
        $originalMedia = $media; // Save for debug
        
        // Check if it's a virtual route BEFORE conversion
        $isVirtualRoute = strpos($originalMedia, '/admin-file/') === 0 ||
                  strpos($originalMedia, '/chat-image/') === 0 ||
                          strpos($originalMedia, '/forum-image/') === 0 ||
                          strpos($originalMedia, '/profile-photo/') === 0 ||
                          strpos($originalMedia, '/site-file/') === 0;
        
        $youtubeId = extractYouTubeIdFromUrl($media);
        $isYouTube = $youtubeId !== '';
        if ($isYouTube) {
            $media = 'https://www.youtube-nocookie.com/embed/' . $youtubeId
                . '?autoplay=1&mute=1&loop=1&playlist=' . $youtubeId
                . '&controls=0&disablekb=1&modestbranding=1&rel=0&playsinline=1'
                . '&showinfo=0&iv_load_policy=3&fs=0&cc_load_policy=0';
        } elseif (function_exists('toPublicFilePath')) {
            $media = toPublicFilePath($media);
        }
        
        $isVideo = !$isYouTube && preg_match('/\.(mp4|webm|ogg)$/i', $media);

        $videoPoster = '';
        if ($isVideo && isset($db) && strpos($originalMedia, '/admin-file/') === 0) {
            if (!array_key_exists($originalMedia, $videoMetaByPath)) {
                $metaStmt = $db->prepare("SELECT thumbnail_path FROM files WHERE file_path = ? LIMIT 1");
                $metaStmt->execute([$originalMedia]);
                $videoMetaByPath[$originalMedia] = $metaStmt->fetch() ?: null;
            }
            $videoMeta = $videoMetaByPath[$originalMedia];
            if ($videoMeta && !empty($videoMeta['thumbnail_path'])) {
                $videoPoster = function_exists('toPublicFilePath')
                    ? toPublicFilePath($videoMeta['thumbnail_path'])
                    : (string)$videoMeta['thumbnail_path'];
            }
        }

        if (!$isYouTube && !empty($media) && !$isVirtualRoute && strpos($media, 'http') !== 0 && strpos($media, 'data:') !== 0) {
            $localPath = PUBLIC_PATH . $media;
            if (!is_file($localPath)) {
                $media = '/assets/images/placeholder-1.svg';
                $isVideo = false;
            }
        }
    ?>
    <div class="split-slide <?php echo $index === 0 ? 'active' : ''; ?>">
        <div class="split-slide-inner">
            <div class="split-content">
                <h2><?php echo e($slide['title'] ?? 'Slide Title'); ?></h2>
                <p><?php echo e($slide['description'] ?? 'Slide description goes here.'); ?></p>
                <?php if ($buttonText !== '' && $buttonUrl !== ''): ?>
                <a href="<?php echo e($buttonUrl); ?>" class="btn btn-primary"<?php echo $buttonTarget !== '' ? ' target="' . e($buttonTarget) . '"' : ''; ?><?php echo $buttonRel !== '' ? ' rel="' . e($buttonRel) . '"' : ''; ?>>
                    <?php echo e($buttonText); ?>
                </a>
                <?php endif; ?>
            </div>
            <div class="split-media">
                <?php if ($isYouTube): ?>
                <iframe src="<?php echo e($media); ?>" title="<?php echo e($slide['title'] ?? 'Embedded video'); ?>" allow="autoplay; encrypted-media; picture-in-picture" allowfullscreen loading="lazy"></iframe>
                <?php elseif ($isVideo): ?>
                <video src="<?php echo e($media); ?>" autoplay muted loop playsinline preload="metadata"<?php echo $videoPoster !== '' ? ' poster="' . e($videoPoster) . '"' : ''; ?>>
                    <track kind="captions" srclang="en" label="English captions" src="data:text/vtt,WEBVTT%0A%0A">
                    <track kind="descriptions" srclang="en" label="English descriptions" src="data:text/vtt,WEBVTT%0A%0A">
                </video>
                <?php else: ?>
                <div class="split-image">
                    <?php
                    // Responsive hero image: serve at widths suited to common viewports
                    // Split slideshow max-width is 2200px; image fills full section width
                    $slideSizes = '(max-width: 2200px) 100vw, 2200px';
                    $slideWidths = [480, 768, 1200, 1920];
                    $slideLoadAttr = $index > 0 ? 'loading="lazy" decoding="async"' : 'fetchpriority="high"';
                    renderSiteImage($media, $slide['title'] ?? 'Slide', $slideWidths, $slideSizes, 'split-image-media', $slideLoadAttr);
                    ?>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <?php endforeach; ?>
    
    <?php if ($showDots && count($slides) > 1): ?>
    <div class="slideshow-nav">
        <?php foreach ($slides as $dotIndex => $dotSlide): ?>
        <button class="slideshow-dot <?php echo $dotIndex === 0 ? 'active' : ''; ?>" data-index="<?php echo $dotIndex; ?>" aria-label="<?php echo \e('Go to slide ' . ($dotIndex + 1)); ?>"></button>
        <?php endforeach; ?>
    </div>
    <?php endif; ?>
    
    <?php if ($showArrows && count($slides) > 1): ?>
    <div class="slideshow-arrows">
        <button class="slideshow-arrow prev" aria-label="Previous slide">&#10094;</button>
        <button class="slideshow-arrow next" aria-label="Next slide">&#10095;</button>
    </div>
    <?php endif; ?>
</section>
