<?php
use NewSite\Cleanup\MissingUploadsService;

/**
 * Image Banner Section Template
 * Compact banner with background images, text overlay, and optional auto-sliding
 */

$images = $sectionSettings['images'] ?? [];
$title = $sectionSettings['title'] ?? '';
$subtitle = $sectionSettings['subtitle'] ?? '';
$titleSize = (int)($sectionSettings['title_size'] ?? 48);
$subtitleSize = (int)($sectionSettings['subtitle_size'] ?? 18);
$textAlign = $sectionSettings['text_align'] ?? 'center';
$height = (int)($sectionSettings['height'] ?? 300);
$spacingTop = (int)($sectionSettings['spacing_top'] ?? 0);
$spacingBottom = (int)($sectionSettings['spacing_bottom'] ?? 0);
$autoplay = $sectionSettings['autoplay'] ?? true;
$interval = (int)($sectionSettings['interval'] ?? 5);
$overlayOpacity = (int)($sectionSettings['overlay_opacity'] ?? 50);
$imagePosition = $sectionSettings['image_position'] ?? 'center';
$textPosition = $sectionSettings['text_position'] ?? 'center';

$sectionId = (int)($section['id'] ?? 0);
$sectionClass = $sectionId > 0 ? 'section-id-' . $sectionId : '';

// Convert position value to CSS for background
$positionMap = [
    'top' => 'top',
    '25' => '25%',
    'center' => 'center',
    '75' => '75%',
    'bottom' => 'bottom'
];
$bgPositionY = $positionMap[$imagePosition] ?? 'center';

// Convert text position to CSS flexbox justify-content
$textPositionMap = [
    'top' => 'flex-start',
    'center' => 'center',
    'bottom' => 'flex-end'
];
$textJustify = $textPositionMap[$textPosition] ?? 'center';

// Link settings
$linkEnabled = $sectionSettings['link_enabled'] ?? false;
$linkType = $sectionSettings['link_type'] ?? 'custom';
$linkUrl = $sectionSettings['link_url'] ?? '';
$linkPageId = $sectionSettings['link_page_id'] ?? '';
$linkNewTab = $sectionSettings['link_new_tab'] ?? false;

// Resolve link URL
$finalUrl = '';
if ($linkEnabled) {
    if ($linkType === 'page' && !empty($linkPageId)) {
        // Get page slug from database
        $pageStmt = $db->prepare("SELECT slug FROM pages WHERE id = ?");
        $pageStmt->execute([$linkPageId]);
        $pageRow = $pageStmt->fetch();
        if ($pageRow) {
            $finalUrl = '/' . $pageRow['slug'];
        }
    } elseif (!empty($linkUrl)) {
        $finalUrl = $linkUrl;
    }
}

// Filter valid images
$validImages = [];
foreach ($images as $img) {
    if (!empty($img['image'])) {
        $imagePath = $img['image'];
        // External URLs and data URIs are always valid
        if (strpos($imagePath, 'http') === 0 || strpos($imagePath, 'data:') === 0) {
            $validImages[] = $img;
            continue;
        }
        // Use the isMissingUploadPath function which handles /admin-file/ paths correctly
        if (!MissingUploadsService::isMissingPath($imagePath)) {
            $validImages[] = $img;
        }
    }
}

// Use placeholder if no valid images
if (empty($validImages)) {
    $validImages = [['image' => '/assets/images/placeholder-1.svg']];
}

$hasMultiple = count($validImages) > 1;
?>
<section class="section-image-banner <?php echo $linkEnabled && $finalUrl ? 'is-clickable' : ''; ?> <?php echo e($sectionClass); ?>"
         data-autoplay="<?php echo ($autoplay && $hasMultiple) ? 'true' : 'false'; ?>"
         data-interval="<?php echo $interval * 1000; ?>">

    <?php if ($linkEnabled && $finalUrl): ?>
    <a href="<?php echo e($finalUrl); ?>" class="banner-link-overlay" <?php echo $linkNewTab ? 'target="_blank" rel="noopener"' : ''; ?>>
        <span class="sr-only">Go to <?php echo e($title ?: 'linked page'); ?></span>
    </a>
    <?php endif; ?>

    <div class="banner-slides">
        <?php foreach ($validImages as $index => $img): ?>
           <div class="banner-slide <?php echo $index === 0 ? 'active' : ''; ?>" data-slide-index="<?php echo $index; ?>"></div>
        <?php endforeach; ?>
    </div>

    <div class="banner-overlay"></div>

    <div class="banner-content">
        <?php if (!empty($title)): ?>
        <h2 class="banner-title"><?php echo e($title); ?></h2>
        <?php endif; ?>
        <?php if (!empty($subtitle)): ?>
        <p class="banner-subtitle"><?php echo e($subtitle); ?></p>
        <?php endif; ?>
    </div>

    <?php if ($hasMultiple): ?>
    <div class="banner-dots">
        <?php foreach ($validImages as $index => $img): ?>
        <button class="banner-dot <?php echo $index === 0 ? 'active' : ''; ?>" data-index="<?php echo $index; ?>" aria-label="Go to slide <?php echo $index + 1; ?>"></button>
        <?php endforeach; ?>
    </div>
    <?php endif; ?>
</section>
