<?php
$sectionTitle = trim($sectionSettings['section_title'] ?? '');
$titleAlign = $sectionSettings['title_align'] ?? 'center';
$titleAlign = in_array($titleAlign, ['left', 'center', 'right'], true) ? $titleAlign : 'center';
$columns = (int)($sectionSettings['columns'] ?? 3);
$columns = max(2, min(4, $columns));
$showDescription = isset($sectionSettings['show_description']) ? (bool)$sectionSettings['show_description'] : true;
$showImage = isset($sectionSettings['show_image']) ? (bool)$sectionSettings['show_image'] : true;

$layoutMode = $sectionSettings['layout_mode'] ?? 'carousel';
$layoutMode = in_array($layoutMode, ['grid', 'carousel'], true) ? $layoutMode : 'grid';

$collections = $db->query("SELECT * FROM collections ORDER BY created_at DESC")->fetchAll();
if (empty($collections)) {
    return;
}

$useCarousel = $layoutMode === 'carousel' && count($collections) > $columns;
$gridClass = 'collection-list-grid columns-' . $columns . ($useCarousel ? ' is-carousel' : '');

$targetPageIds = array_values(array_unique(array_filter(array_map(function($c) {
    return (int)($c['target_page_id'] ?? 0) ?: null;
}, $collections))));

$pageSlugById = [];
if (!empty($targetPageIds)) {
    $placeholders = implode(',', array_fill(0, count($targetPageIds), '?'));
    $stmt = $db->prepare("SELECT id, slug FROM pages WHERE id IN ($placeholders) AND is_published = 1");
    $stmt->execute($targetPageIds);
    foreach ($stmt->fetchAll() as $page) {
        $pageSlugById[(int)$page['id']] = trim($page['slug'] ?? '');
    }
}

$fallbackSlug = '';
$stmt = $db->query("SELECT p.slug FROM pages p JOIN sections s ON s.page_id = p.id WHERE s.section_type = 'products_list' AND p.is_published = 1 ORDER BY p.id ASC LIMIT 1");
$fallbackRow = $stmt->fetch();
if ($fallbackRow) {
    $fallbackSlug = trim($fallbackRow['slug'] ?? '');
}

$collectionsListSlug = '';
$stmt = $db->prepare("SELECT p.slug FROM pages p JOIN sections s ON s.page_id = p.id WHERE s.section_type = 'collections_list' AND p.is_published = 1 AND p.slug = ? LIMIT 1");
$stmt->execute(['collections']);
$collectionsRow = $stmt->fetch();
if ($collectionsRow) {
    $collectionsListSlug = trim($collectionsRow['slug'] ?? '');
}
if ($collectionsListSlug === '') {
    $stmt = $db->query("SELECT p.slug FROM pages p JOIN sections s ON s.page_id = p.id WHERE s.section_type = 'collections_list' AND p.is_published = 1 ORDER BY p.id ASC LIMIT 1");
    $collectionsRow = $stmt->fetch();
    if ($collectionsRow) {
        $collectionsListSlug = trim($collectionsRow['slug'] ?? '');
    }
}

$showAllUrl = $collectionsListSlug !== '' ? '/' . $collectionsListSlug : '';

$isCollectionsPage = isset($pageSlug) && $collectionsListSlug !== '' && $pageSlug === $collectionsListSlug;
if ($isCollectionsPage) {
    $layoutMode = 'grid';
}
?>
<section class="section-collections-list">
    <div class="container">
        <?php if ($sectionTitle !== ''): ?>
            <div class="products-header text-align-<?php echo e($titleAlign); ?>">
                <h2><?php echo e($sectionTitle); ?></h2>
            </div>
        <?php endif; ?>
        <div class="<?php echo e($gridClass); ?>">
            <?php foreach ($collections as $collection):
                $title = trim($collection['title'] ?? '');
                $description = trim($collection['description'] ?? '');
                $imageUrl = trim($collection['image_url'] ?? '');
                $imageUrl = $imageUrl !== '' ? toPublicFilePath($imageUrl) : '';
                $targetPageId = (int)($collection['target_page_id'] ?? 0);
                $targetSlug = $targetPageId > 0 ? ($pageSlugById[$targetPageId] ?? '') : '';
                if ($targetSlug === '') {
                    $targetSlug = $fallbackSlug;
                }
                $collectionSlug = trim((string)($collection['collection_slug'] ?? ''));
                if ($targetSlug !== '' && $collectionSlug !== '') {
                    $collectionUrl = '/' . $targetSlug . '/collection/' . rawurlencode($collectionSlug);
                } else {
                    $collectionUrl = $targetSlug !== '' ? '/' . $targetSlug . '?collection=' . (int)$collection['id'] : '';
                }
            ?>
                <?php if ($collectionUrl !== ''): ?>
                    <a class="collection-list-card" href="<?php echo e($collectionUrl); ?>">
                        <?php if ($showImage && $imageUrl !== ''): ?>
                            <div class="collection-list-media">
                                <?php
                                $colSizesMap = [2 => '(max-width: 640px) 100vw, (max-width: 900px) 50vw, 50vw', 3 => '(max-width: 640px) 100vw, (max-width: 900px) 50vw, 33vw', 4 => '(max-width: 640px) 100vw, (max-width: 900px) 50vw, 25vw'];
                                $colSizes = $colSizesMap[$columns] ?? $colSizesMap[3];
                                renderSiteImage($imageUrl, $title, [400, 700, 1000], $colSizes, '', 'loading="lazy" decoding="async"');
                                ?>
                            </div>
                        <?php endif; ?>
                        <div class="collection-list-body">
                            <?php if ($title !== ''): ?>
                                <h3 class="collection-list-title"><?php echo e($title); ?></h3>
                            <?php endif; ?>
                            <?php if ($showDescription && $description !== ''): ?>
                                <p class="collection-list-description"><?php echo e($description); ?></p>
                            <?php endif; ?>
                        </div>
                    </a>
                <?php else: ?>
                    <article class="collection-list-card">
                        <?php if ($showImage && $imageUrl !== ''): ?>
                            <div class="collection-list-media">
                                <?php renderSiteImage($imageUrl, $title, [400, 700, 1000], $colSizes, '', 'loading="lazy" decoding="async"'); ?>
                            </div>
                        <?php endif; ?>
                        <div class="collection-list-body">
                            <?php if ($title !== ''): ?>
                                <h3 class="collection-list-title"><?php echo e($title); ?></h3>
                            <?php endif; ?>
                            <?php if ($showDescription && $description !== ''): ?>
                                <p class="collection-list-description"><?php echo e($description); ?></p>
                            <?php endif; ?>
                        </div>
                    </article>
                <?php endif; ?>
            <?php endforeach; ?>
        </div>
        <?php if ($useCarousel && $showAllUrl !== ''): ?>
            <div class="collection-list-footer">
                <a class="btn btn-secondary" href="<?php echo e($showAllUrl); ?>">Show all collections</a>
            </div>
        <?php endif; ?>
    </div>
</section>
