<?php
use NewSite\Shop\CurrencyService;

$searchQuery = trim($searchQuery ?? '');
$resultsPages = [];
$resultsProducts = [];
$resultsMiniGames = [];

if ($searchQuery !== '') {
    $like = '%' . $searchQuery . '%';

    $stmt = $db->prepare("SELECT title, slug, meta_description FROM pages WHERE is_published = 1 AND (title ILIKE ? OR content ILIKE ? OR meta_description ILIKE ?) ORDER BY updated_at DESC LIMIT 20");
    $stmt->execute([$like, $like, $like]);
    $resultsPages = $stmt->fetchAll();

    $stmt = $db->prepare("SELECT p.*, pg.slug AS page_slug, pm.media_url AS gallery_media FROM products p LEFT JOIN pages pg ON pg.id = p.page_id LEFT JOIN product_media pm ON pm.product_id = p.id AND pm.sort_order = 0 WHERE p.is_active = 1 AND (p.name ILIKE ? OR p.description ILIKE ?) ORDER BY p.updated_at DESC LIMIT 20");
    $stmt->execute([$like, $like]);
    $resultsProducts = $stmt->fetchAll();

    $queryNeedle = strtolower($searchQuery);
    foreach (\NewSite\Minigames\MinigameRepository::getEnabled($db) as $game) {
        $title = strtolower((string)($game['title'] ?? ''));
        $description = strtolower((string)($game['description'] ?? ''));
        $slug = strtolower((string)($game['slug'] ?? ''));

        if (
            strpos($title, $queryNeedle) !== false
            || strpos($description, $queryNeedle) !== false
            || strpos($slug, $queryNeedle) !== false
        ) {
            $resultsMiniGames[] = $game;
        }
    }
}

function formatSearchPrice(string $price): string
{
    return CurrencyService::formatValue($price, CurrencyService::getCurrent());
}
?>

<section class="search-section">
    <div class="container">
        <div class="search-header">
            <h1>Search</h1>
            <form class="search-form search-widget" method="GET" action="/search" data-search-widget>
                <input type="text" name="q" placeholder="Search pages, products, or mini-games" value="<?php echo e($searchQuery); ?>" data-search-input>
                <button type="submit" aria-label="Search">Search</button>
                <div class="search-suggest" data-search-suggest></div>
            </form>
        </div>

        <?php if ($searchQuery === ''): ?>
            <div class="search-empty">Enter a search term to find pages, products, or mini-games.</div>
        <?php else: ?>
            <div class="search-summary">
                Showing results for <strong><?php echo e($searchQuery); ?></strong>
            </div>

            <?php if (empty($resultsPages) && empty($resultsProducts) && empty($resultsMiniGames)): ?>
                <div class="search-empty">No results found.</div>
            <?php endif; ?>

            <?php if (!empty($resultsPages)): ?>
                <div class="search-block">
                    <h2>Pages</h2>
                    <div class="search-list">
                        <?php foreach ($resultsPages as $page): ?>
                            <a class="search-item" href="/<?php echo e($page['slug']); ?>">
                                <div>
                                    <h3><?php echo e($page['title']); ?></h3>
                                    <?php if (!empty($page['meta_description'])): ?>
                                        <p><?php echo e($page['meta_description']); ?></p>
                                    <?php endif; ?>
                                </div>
                                <span class="search-type">Page</span>
                            </a>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endif; ?>

            <?php if (!empty($resultsProducts)): ?>
                <div class="search-block">
                    <h2>Products</h2>
                    <div class="search-list">
                        <?php foreach ($resultsProducts as $product):
                            $name = trim($product['name'] ?? '');
                            $price = trim($product['price'] ?? '');
                            $displayPrice = formatSearchPrice($price);
                            $mediaUrl = toPublicFilePath(trim($product['gallery_media'] ?? $product['media_url'] ?? ''));
                            $pageSlug = trim($product['page_slug'] ?? '');
                            $productSlug = trim((string)($product['product_slug'] ?? ''));
                            if ($pageSlug !== '' && $productSlug !== '') {
                                $productUrl = '/' . $pageSlug . '/' . rawurlencode($productSlug);
                            } else {
                                $productUrl = $pageSlug !== '' ? '/' . $pageSlug . '?product=' . (int)$product['id'] : '';
                            }
                            ?>
                            <?php if ($productUrl !== ''): ?>
                                <a class="search-item" href="<?php echo e($productUrl); ?>">
                                    <?php if ($mediaUrl !== ''): ?>
                                        <div class="search-thumb"><img src="<?php echo e($mediaUrl); ?>" alt="<?php echo e($name); ?>"></div>
                                    <?php endif; ?>
                                    <div>
                                        <h3><?php echo e($name); ?></h3>
                                        <?php if ($displayPrice !== ''): ?>
                                            <p><?php echo e($displayPrice); ?></p>
                                        <?php endif; ?>
                                    </div>
                                    <span class="search-type">Product</span>
                                </a>
                            <?php else: ?>
                                <div class="search-item search-item-disabled">
                                    <?php if ($mediaUrl !== ''): ?>
                                        <div class="search-thumb"><img src="<?php echo e($mediaUrl); ?>" alt="<?php echo e($name); ?>"></div>
                                    <?php endif; ?>
                                    <div>
                                        <h3><?php echo e($name); ?></h3>
                                        <?php if ($displayPrice !== ''): ?>
                                            <p><?php echo e($displayPrice); ?></p>
                                        <?php endif; ?>
                                    </div>
                                    <span class="search-type">Product</span>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endif; ?>

            <?php if (!empty($resultsMiniGames)): ?>
                <div class="search-block">
                    <h2>Mini-Games</h2>
                    <div class="search-list">
                        <?php foreach ($resultsMiniGames as $game):
                            $gameTitle = trim((string)($game['title'] ?? ''));
                            $gameDescription = trim((string)($game['description'] ?? ''));
                            $gameSlug = trim((string)($game['slug'] ?? ''));
                            $gamePublicSlug = $gameSlug !== '' ? \NewSite\Minigames\MinigameCatalog::getPublicSlug($gameSlug) : '';
                            $gameUrl = $gamePublicSlug !== '' ? '/games/' . $gamePublicSlug : '';
                            ?>
                            <?php if ($gameUrl !== ''): ?>
                                <a class="search-item" href="<?php echo e($gameUrl); ?>">
                                    <div>
                                        <h3><?php echo e($gameTitle); ?></h3>
                                        <?php if ($gameDescription !== ''): ?>
                                            <p><?php echo e($gameDescription); ?></p>
                                        <?php endif; ?>
                                    </div>
                                    <span class="search-type">Mini-Game</span>
                                </a>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</section>
