<?php
use NewSite\Auth\SiteAuth;
use NewSite\Database\DatabaseManager;
use NewSite\Logging\LogService;
use NewSite\User\UserMessageService;
use NewSite\User\UserService;

SiteAuth::requireLogin();
$userId = (int)($_SESSION['site_user_id'] ?? 0);
$messages = UserMessageService::getMessages((int)$userId, 50);
$selectedId = (int)($_GET['message'] ?? 0);
$replyMessage = '';
$replyError = '';
$selectedThreadId = (int)($_GET['ticket'] ?? 0);
$messageDateFormat = 'M j, Y g:i A';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    if ($action === 'reply_message') {
        $replyToId = (int)($_POST['reply_to_id'] ?? 0);
        $body = trim($_POST['reply_body'] ?? '');
        if ($replyToId <= 0 || $body === '') {
            $replyError = 'Reply message is required.';
        } else {
            $db = DatabaseManager::getWriteConnection();
            $stmt = $db->prepare("SELECT id, subject, sender_type, message_type, reply_to_id FROM user_messages WHERE id = ? AND user_id = ? LIMIT 1");
            $stmt->execute([$replyToId, $userId]);
            $original = $stmt->fetch();
            if (!$original) {
                $replyError = 'Message not found.';
            } elseif (($original['sender_type'] ?? 'admin') !== 'admin' || ($original['message_type'] ?? 'notice') !== 'ticket') {
                $replyError = 'Replies are only available for ticket messages.';
            } else {
                $base = trim((string)($original['subject'] ?? ''));
                $subject = $base !== '' ? $base : 'Ticket';
                $threadId = (int)($original['reply_to_id'] ?? 0);
                if ($threadId <= 0) {
                    $threadId = (int)$original['id'];
                }
                $user = UserService::getById((int)$userId);
                $senderLabel = trim((string)($user['email'] ?? 'User'));
                $stmt = $db->prepare("INSERT INTO user_messages (user_id, subject, body, sender_type, sender_label, reply_to_id, message_type, is_read, created_at) VALUES (?, ?, ?, 'user', ?, ?, 'ticket', 1, ?)");
                $stmt->execute([$userId, $subject, $body, $senderLabel, $threadId, time()]);
                LogService::add('info', 'User replied to ticket', json_encode(['user_id' => $userId, 'reply_to' => $threadId]));
                $replyMessage = 'Reply sent successfully.';
            }
        }
    }
    $messages = UserMessageService::getMessages((int)$userId, 50);
}

$db = DatabaseManager::getWriteConnection();
$stmt = $db->prepare("SELECT * FROM user_messages WHERE user_id = ? AND (message_type = 'ticket' OR subject = 'Ticket') ORDER BY created_at DESC LIMIT 200");
$stmt->execute([$userId]);
$ticketMessages = $stmt->fetchAll();

$ticketChat = null;
$conversation = [];
if (!empty($ticketMessages)) {
    $latest = $ticketMessages[0];
    $ticketChat = [
        'root_id' => 1,
        'subject' => 'Support Chat',
        'preview' => $latest['body'] ?? '',
        'last_time' => (int)($latest['created_at'] ?? 0)
    ];
}

if ($selectedThreadId > 0 && $ticketChat) {
    $conversation = array_reverse($ticketMessages);
}
?>

<section class="auth-section">
    <div class="container">
        <div class="auth-card">
            <h1>Message Center</h1>
            <p class="auth-subtitle">Your latest messages.</p>

            <div class="account-tabs">
                <a href="/messages" class="account-tab active">Message Center</a>
                <a href="/account-settings" class="account-tab">Account Settings</a>
            </div>

            <?php if ($replyMessage): ?>
                <div class="auth-alert success"><?php echo e($replyMessage); ?></div>
            <?php endif; ?>

            <?php if ($replyError): ?>
                <div class="auth-alert error"><?php echo e($replyError); ?></div>
            <?php endif; ?>

            <?php if (empty($messages) && !$ticketChat): ?>
                <div class="auth-alert">No messages yet.</div>
            <?php else: ?>
                <?php if ($ticketChat): ?>
                    <div class="ticket-layout">
                        <div class="ticket-list">
                            <?php
                            $isActive = $selectedThreadId > 0;
                    $preview = trim((string)($ticketChat['preview'] ?? ''));
                    $preview = $preview !== '' ? mb_substr($preview, 0, 80) : '';
                    ?>
                            <a class="ticket-list-item <?php echo $isActive ? 'is-active' : ''; ?>" href="/messages?ticket=1">
                                <div class="ticket-list-title">Support Chat</div>
                                <?php if ($preview !== ''): ?>
                                    <div class="ticket-list-preview"><?php echo e($preview); ?><?php echo strlen($preview) >= 80 ? '…' : ''; ?></div>
                                <?php endif; ?>
                                <div class="ticket-list-time"><?php echo !empty($ticketChat['last_time']) ? date($messageDateFormat, (int)$ticketChat['last_time']) : '-'; ?></div>
                            </a>
                        </div>
                        <div class="ticket-chat">
                            <?php if (empty($conversation)): ?>
                                <div class="text-muted">Select a ticket to view the conversation.</div>
                            <?php else: ?>
                                <?php
                        $replyToId = (int)($conversation[0]['id'] ?? 0);
                                ?>
                                <div class="ticket-chat-header">
                                    <div>
                                        <h4>Support Chat</h4>
                                        <div class="ticket-chat-subject">Ticket conversation</div>
                                    </div>
                                </div>
                                <div class="ticket-chat-body">
                                    <?php foreach ($conversation as $row): ?>
                                        <?php $isAdmin = ($row['sender_type'] ?? 'admin') === 'admin'; ?>
                                        <div class="ticket-bubble <?php echo $isAdmin ? 'ticket-bubble--admin' : 'ticket-bubble--user'; ?>">
                                            <div class="ticket-bubble-meta">
                                                <?php echo $isAdmin ? 'Admin' : 'You'; ?>
                                                · <?php echo !empty($row['created_at']) ? date($messageDateFormat, (int)$row['created_at']) : '-'; ?>
                                                <?php if (!$isAdmin): ?>
                                                    <?php if (!empty($row['admin_read'])): ?>
                                                        <span class="read-receipt read-receipt--read" title="Seen"><svg viewBox="0 0 16 16" fill="currentColor"><path d="M13.854 3.646a.5.5 0 0 1 0 .708l-7 7a.5.5 0 0 1-.708 0l-3.5-3.5a.5.5 0 1 1 .708-.708L6.5 10.293l6.646-6.647a.5.5 0 0 1 .708 0z"/></svg></span>
                                                    <?php else: ?>
                                                        <span class="read-receipt read-receipt--sent" title="Sent"><svg viewBox="0 0 16 16" fill="currentColor"><path d="M13.854 3.646a.5.5 0 0 1 0 .708l-7 7a.5.5 0 0 1-.708 0l-3.5-3.5a.5.5 0 1 1 .708-.708L6.5 10.293l6.646-6.647a.5.5 0 0 1 .708 0z"/></svg></span>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </div>
                                            <div class="ticket-bubble-text"><?php echo e($row['body'] ?? ''); ?></div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                                <form method="POST" action="/messages" class="ticket-reply-form">
                                    <input type="hidden" name="csrf_token" value="<?php echo e(getCsrfToken()); ?>">
                                    <input type="hidden" name="action" value="reply_message">
                                    <input type="hidden" name="reply_to_id" value="<?php echo (int)$replyToId; ?>">
                                    <div class="form-group">
                                        <label for="ticket-reply-body">Message</label>
                                        <textarea id="ticket-reply-body" name="reply_body" rows="3" placeholder="Write your reply..."></textarea>
                                    </div>
                                    <button type="submit" class="btn btn-outline btn-sm">Send Reply</button>
                                </form>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>

                <?php
                $noticeMessages = array_filter($messages, static function ($row) {
                    $type = $row['message_type'] ?? 'notice';
                    $subject = $row['subject'] ?? '';
                    $replyToId = $row['reply_to_id'] ?? 0;
                    $isTicketType = ($type === 'ticket' || $type === 'chat');
                    $hasTicketSubject = stripos($subject, 'ticket') !== false;
                    $isReply = !empty($replyToId);
                    return !$isTicketType && !$hasTicketSubject && !$isReply;
                });
?>
                <?php if (!empty($noticeMessages)): ?>
                    <h3 class="mt-3">Other Messages</h3>
                    <div class="message-list" data-message-list>
                        <?php foreach ($noticeMessages as $message): ?>
                            <?php
            $bodyText = $message['body'] ?? '';
                            $preview = mb_strlen($bodyText) > 100 ? mb_substr($bodyText, 0, 100) . '…' : $bodyText;
                            ?>
                            <div class="message-item message-item--list <?php echo empty($message['is_read']) ? 'is-unread' : ''; ?>" id="message-<?php echo (int)$message['id']; ?>" data-message-id="<?php echo (int)$message['id']; ?>">
                                <div class="message-head">
                                    <div class="message-title"><?php echo e($message['subject'] ?: 'Message'); ?></div>
                                    <form method="POST" action="/account?tab=messages" class="message-delete-form" data-confirm="Delete this message?">
                                        <input type="hidden" name="csrf_token" value="<?php echo e(getCsrfToken()); ?>">
                                        <input type="hidden" name="action" value="delete_message">
                                        <input type="hidden" name="message_id" value="<?php echo (int)$message['id']; ?>">
                                        <button type="submit" class="message-delete" aria-label="Delete message">🗑️</button>
                                    </form>
                                </div>
                                <?php if ($preview !== ''): ?>
                                    <div class="message-preview"><?php echo e($preview); ?></div>
                                <?php endif; ?>
                                <div class="message-time">
                                    <?php echo !empty($message['created_at']) ? date($messageDateFormat, (int)$message['created_at']) : ''; ?>
                                </div>
                                <?php if (!empty($bodyText)): ?>
                                    <div class="message-body message-body--full is-hidden" data-message-body><?php echo e($bodyText); ?></div>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    </div>
</section>
