<?php
use NewSite\Util\AssetVersioning;

/**
 * Basketball Game Template — Arcade Machine
 * Rendered inside the games page when slug = 'basketball'.
 */
?>
<div class="games-page">
    <div class="container">
        <div class="game-header">
            <a href="/games" class="btn btn-outline btn-sm">&larr; All Games</a>
            <h1>🏀 Arcade Basketball</h1>
        </div>

        <div class="game-scoreboard">
            <div class="game-stat game-stat-timer">
                <span class="game-stat-label">Timer</span>
                <span class="game-stat-value" id="basketball-timer">45</span>
            </div>
            <div class="game-stat">
                <span class="game-stat-label">Score</span>
                <span class="game-stat-value" id="basketball-score">0</span>
            </div>
            <div class="game-stat">
                <span class="game-stat-label">Shots</span>
                <span class="game-stat-value" id="basketball-attempts">0</span>
            </div>
            <div class="game-stat">
                <span class="game-stat-label">Streak</span>
                <span class="game-stat-value" id="basketball-streak">0</span>
            </div>
            <div class="game-stat">
                <span class="game-stat-label">Best</span>
                <span class="game-stat-value" id="basketball-best">0</span>
            </div>
        </div>

        <div class="game-canvas-wrap">
            <canvas id="basketball-canvas"></canvas>
        </div>

        <div class="game-instructions">
            <p><strong>How to play:</strong> Tap to start a 45-second round. Grab the ball and flick it upward toward the hoop. Aim left or right to adjust your shot. The ball bounces off the rim and backboard with real physics! Every 3 consecutive scores earns +3 bonus seconds.</p>
        </div>
    </div>
</div>

<script nonce="<?php echo e(getCspNonce()); ?>" src="<?php echo AssetVersioning::url('/assets/js/game-basketball.js'); ?>"></script>
