<?php
use NewSite\User\FriendService;
use NewSite\User\UserService;

/**
 * Friends Page
 * Shows friends list, pending requests, sent requests, search, and blocked users
 */

$userId = (int)$_SESSION['site_user_id'];
$currentUser = UserService::getById((int)$userId);
$tab = $_GET['tab'] ?? 'all';
$validTabs = ['all', 'pending', 'sent', 'blocked'];
if (!in_array($tab, $validTabs)) {
    $tab = 'all';
}

// Get data based on tab
$friends = [];
$pendingRequests = [];
$sentRequests = [];
$blockedUsers = [];

if ($tab === 'all') {
    $friends = FriendService::getList((int)$userId);
}
if ($tab === 'pending' || $tab === 'all') {
    $pendingRequests = FriendService::getPendingRequests((int)$userId);
}
if ($tab === 'sent') {
    $sentRequests = FriendService::getSentRequests((int)$userId);
}
if ($tab === 'blocked') {
    $blockedUsers = FriendService::getBlockedUsers((int)$userId);
}

$pendingCount = count($pendingRequests);
$friendCount = FriendService::getCount((int)$userId);

// Flash messages
$flashMessage = $_SESSION['friend_flash_message'] ?? '';
$flashError = $_SESSION['friend_flash_error'] ?? '';
unset($_SESSION['friend_flash_message'], $_SESSION['friend_flash_error']);

// Search query
$searchQuery = trim($_GET['q'] ?? '');
$searchResults = [];
if ($searchQuery !== '') {
    $searchResults = FriendService::searchUsers($searchQuery, $userId, 20);
}
?>

<div class="friends-container">
    <div class="friends-header">
        <h1>Friends</h1>
        <?php if ($currentUser['nickname']): ?>
            <a href="/@<?php echo e($currentUser['nickname']); ?>" class="btn btn-outline btn-sm">View My Profile</a>
        <?php endif; ?>
    </div>

    <?php if ($flashMessage): ?>
        <div class="alert alert-success"><?php echo e($flashMessage); ?></div>
    <?php endif; ?>
    <?php if ($flashError): ?>
        <div class="alert alert-error"><?php echo e($flashError); ?></div>
    <?php endif; ?>

    <!-- Search Section -->
    <div class="friends-search-section">
        <form method="get" action="/friends" class="friends-search-form">
            <input type="hidden" name="tab" value="<?php echo e($tab); ?>">
            <div class="search-input-wrapper">
                <svg viewBox="0 0 24 24" width="20" height="20" fill="none" stroke="currentColor" stroke-width="2" class="search-icon">
                    <circle cx="11" cy="11" r="8"></circle>
                    <line x1="21" y1="21" x2="16.65" y2="16.65"></line>
                </svg>
                <input type="text" name="q" value="<?php echo e($searchQuery); ?>" placeholder="Search by @nickname or name..." class="friends-search-input">
                <button type="submit" class="btn btn-primary">Search</button>
                <?php if ($searchQuery): ?>
                    <a href="/friends?tab=<?php echo e($tab); ?>" class="btn btn-outline">Clear</a>
                <?php endif; ?>
            </div>
        </form>
    </div>

    <?php if ($searchQuery && !empty($searchResults)): ?>
    <!-- Search Results -->
    <div class="friends-section">
        <h2 class="friends-section-title">Search Results for "<?php echo e($searchQuery); ?>"</h2>
        <div class="friends-grid">
            <?php foreach ($searchResults as $user):
                $status = FriendService::getStatus((int)$userId, (int)$user['id']);
                ?>
            <div class="friend-card">
                <a href="/@<?php echo e($user['nickname']); ?>" class="friend-card-photo-link">
                    <?php if (!empty($user['profile_photo'])): ?>
                        <img src="<?php echo e(toPublicFilePath($user['profile_photo'])); ?>" alt="" class="friend-card-photo">
                    <?php else: ?>
                        <div class="friend-card-photo-placeholder">
                            <?php echo strtoupper(substr($user['display_name'] ?? $user['nickname'] ?? '?', 0, 1)); ?>
                        </div>
                    <?php endif; ?>
                </a>
                <div class="friend-card-info">
                    <a href="/@<?php echo e($user['nickname']); ?>" class="friend-card-name">
                        <?php echo e($user['display_name'] ?: $user['nickname']); ?>
                    </a>
                    <span class="friend-card-nickname">@<?php echo e($user['nickname']); ?></span>
                </div>
                <div class="friend-card-actions">
                    <?php if ($status === 'friends'): ?>
                        <span class="friend-status-badge">✓ Friends</span>
                        <button type="button" class="btn btn-primary btn-sm" data-messenger-open="<?php echo $user['id']; ?>" data-messenger-name="<?php echo e($user['display_name'] ?: $user['nickname']); ?>" data-messenger-nickname="<?php echo e($user['nickname'] ?? $user['display_name'] ?? ''); ?>" data-messenger-avatar="<?php echo e(toPublicFilePath($user['profile_photo'] ?? '')); ?>" data-messenger-status="<?php echo e($user['status'] ?? 'offline'); ?>">Message</button>
                    <?php elseif ($status === 'request_sent'): ?>
                        <span class="friend-status-badge pending">Pending</span>
                    <?php elseif ($status === 'request_received'): ?>
                        <span class="friend-status-badge incoming">Accept?</span>
                    <?php elseif ($status === 'blocked'): ?>
                        <span class="friend-status-badge blocked">Blocked</span>
                    <?php else: ?>
                        <button type="button" class="btn btn-icon btn-primary has-tooltip" data-friend-action="send_request" data-target-user="<?php echo $user['id']; ?>" data-tooltip="Send Friend Request">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="3" stroke-linecap="round"><line x1="12" y1="5" x2="12" y2="19"/><line x1="5" y1="12" x2="19" y2="12"/></svg>
                        </button>
                    <?php endif; ?>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
    <?php elseif ($searchQuery): ?>
    <div class="friends-empty">
        <p>No users found matching "<?php echo e($searchQuery); ?>"</p>
    </div>
    <?php endif; ?>

    <!-- Tabs -->
    <div class="friends-tabs">
        <a href="/friends?tab=all" class="friends-tab <?php echo $tab === 'all' ? 'active' : ''; ?>">
            All Friends
            <?php if ($friendCount > 0): ?>
                <span class="tab-count"><?php echo $friendCount; ?></span>
            <?php endif; ?>
        </a>
        <a href="/friends?tab=pending" class="friends-tab <?php echo $tab === 'pending' ? 'active' : ''; ?>">
            Pending Requests
            <?php if ($pendingCount > 0): ?>
                <span class="tab-count tab-count-alert"><?php echo $pendingCount; ?></span>
            <?php endif; ?>
        </a>
        <a href="/friends?tab=sent" class="friends-tab <?php echo $tab === 'sent' ? 'active' : ''; ?>">
            Sent Requests
        </a>
        <a href="/friends?tab=blocked" class="friends-tab <?php echo $tab === 'blocked' ? 'active' : ''; ?>">
            Blocked
        </a>
    </div>

    <!-- Tab Content -->
    <?php if ($tab === 'all'): ?>
        <?php if ($pendingCount > 0): ?>
        <div class="friends-section pending-highlight">
            <h2 class="friends-section-title">
                <span class="pending-dot"></span>
                <?php echo $pendingCount; ?> Pending Request<?php echo $pendingCount !== 1 ? 's' : ''; ?>
            </h2>
            <div class="friends-grid">
                <?php foreach ($pendingRequests as $request): ?>
                <div class="friend-card friend-card-pending">
                    <a href="/@<?php echo e($request['nickname']); ?>" class="friend-card-photo-link">
                        <?php if (!empty($request['profile_photo'])): ?>
                            <img src="<?php echo e(toPublicFilePath($request['profile_photo'])); ?>" alt="" class="friend-card-photo">
                        <?php else: ?>
                            <div class="friend-card-photo-placeholder">
                                <?php echo strtoupper(substr($request['display_name'] ?? $request['nickname'] ?? '?', 0, 1)); ?>
                            </div>
                        <?php endif; ?>
                    </a>
                    <div class="friend-card-info">
                        <a href="/@<?php echo e($request['nickname']); ?>" class="friend-card-name">
                            <?php echo e($request['display_name'] ?: $request['nickname']); ?>
                        </a>
                        <span class="friend-card-nickname">@<?php echo e($request['nickname']); ?></span>
                        <?php if (!empty($request['message'])): ?>
                            <p class="friend-request-message">"<?php echo e($request['message']); ?>"</p>
                        <?php endif; ?>
                    </div>
                    <div class="friend-card-actions">
                        <form method="post" class="inline-form">
                            <input type="hidden" name="csrf_token" value="<?php echo e(getCsrfToken()); ?>">
                            <input type="hidden" name="friend_action" value="accept_request">
                            <input type="hidden" name="request_id" value="<?php echo $request['id']; ?>">
                            <input type="hidden" name="return_url" value="/friends?tab=all">
                            <button type="submit" class="btn btn-primary btn-sm">Accept</button>
                        </form>
                        <form method="post" class="inline-form">
                            <input type="hidden" name="csrf_token" value="<?php echo e(getCsrfToken()); ?>">
                            <input type="hidden" name="friend_action" value="decline_request">
                            <input type="hidden" name="request_id" value="<?php echo $request['id']; ?>">
                            <input type="hidden" name="return_url" value="/friends?tab=all">
                            <button type="submit" class="btn btn-outline btn-sm">Decline</button>
                        </form>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>

        <div class="friends-section">
            <h2 class="friends-section-title">All Friends (<?php echo $friendCount; ?>)</h2>
            <?php if (empty($friends)): ?>
                <div class="friends-empty">
                    <svg viewBox="0 0 24 24" width="48" height="48" fill="none" stroke="currentColor" stroke-width="1.5">
                        <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path>
                        <circle cx="9" cy="7" r="4"></circle>
                        <path d="M23 21v-2a4 4 0 0 0-3-3.87"></path>
                        <path d="M16 3.13a4 4 0 0 1 0 7.75"></path>
                    </svg>
                    <p>You don't have any friends yet.</p>
                    <p class="text-muted">Search for users by their @nickname to connect!</p>
                </div>
            <?php else: ?>
                <div class="friends-grid">
                    <?php foreach ($friends as $friend): ?>
                    <div class="friend-card">
                        <a href="/@<?php echo e($friend['nickname']); ?>" class="friend-card-photo-link">
                            <?php if (!empty($friend['profile_photo'])): ?>
                                <img src="<?php echo e(toPublicFilePath($friend['profile_photo'])); ?>" alt="" class="friend-card-photo">
                            <?php else: ?>
                                <div class="friend-card-photo-placeholder">
                                    <?php echo strtoupper(substr($friend['display_name'] ?? $friend['nickname'] ?? '?', 0, 1)); ?>
                                </div>
                            <?php endif; ?>
                        </a>
                        <div class="friend-card-info">
                            <a href="/@<?php echo e($friend['nickname']); ?>" class="friend-card-name">
                                <?php echo e($friend['display_name'] ?: $friend['nickname']); ?>
                            </a>
                            <span class="friend-card-nickname">@<?php echo e($friend['nickname']); ?></span>
                        </div>
                        <div class="friend-card-actions">
                            <button type="button" class="btn btn-primary btn-sm" data-messenger-open="<?php echo $friend['id']; ?>" data-messenger-name="<?php echo e($friend['display_name'] ?: $friend['nickname']); ?>" data-messenger-nickname="<?php echo e($friend['nickname'] ?? $friend['display_name'] ?? ''); ?>" data-messenger-avatar="<?php echo e(toPublicFilePath($friend['profile_photo'] ?? '')); ?>" data-messenger-status="<?php echo e($friend['status'] ?? 'offline'); ?>">Message</button>
                            <a href="/@<?php echo e($friend['nickname']); ?>" class="btn btn-outline btn-sm">Profile</a>
                            <form method="post" class="inline-form" data-confirm="Remove this friend?">
                                <input type="hidden" name="csrf_token" value="<?php echo e(getCsrfToken()); ?>">
                                <input type="hidden" name="friend_action" value="remove_friend">
                                <input type="hidden" name="target_user_id" value="<?php echo $friend['id']; ?>">
                                <input type="hidden" name="return_url" value="/friends?tab=all">
                                <button type="submit" class="btn btn-outline btn-sm btn-danger">Remove</button>
                            </form>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>

    <?php elseif ($tab === 'pending'): ?>
        <div class="friends-section">
            <h2 class="friends-section-title">Pending Friend Requests</h2>
            <?php if (empty($pendingRequests)): ?>
                <div class="friends-empty">
                    <p>No pending friend requests.</p>
                </div>
            <?php else: ?>
                <div class="friends-grid">
                    <?php foreach ($pendingRequests as $request): ?>
                    <div class="friend-card friend-card-pending">
                        <a href="/@<?php echo e($request['nickname']); ?>" class="friend-card-photo-link">
                            <?php if (!empty($request['profile_photo'])): ?>
                                <img src="<?php echo e(toPublicFilePath($request['profile_photo'])); ?>" alt="" class="friend-card-photo">
                            <?php else: ?>
                                <div class="friend-card-photo-placeholder">
                                    <?php echo strtoupper(substr($request['display_name'] ?? $request['nickname'] ?? '?', 0, 1)); ?>
                                </div>
                            <?php endif; ?>
                        </a>
                        <div class="friend-card-info">
                            <a href="/@<?php echo e($request['nickname']); ?>" class="friend-card-name">
                                <?php echo e($request['display_name'] ?: $request['nickname']); ?>
                            </a>
                            <span class="friend-card-nickname">@<?php echo e($request['nickname']); ?></span>
                            <?php if (!empty($request['message'])): ?>
                                <p class="friend-request-message">"<?php echo e($request['message']); ?>"</p>
                            <?php endif; ?>
                            <span class="friend-card-date">Received <?php echo date('M j', strtotime($request['created_at'])); ?></span>
                        </div>
                        <div class="friend-card-actions">
                            <form method="post" class="inline-form">
                                <input type="hidden" name="csrf_token" value="<?php echo e(getCsrfToken()); ?>">
                                <input type="hidden" name="friend_action" value="accept_request">
                                <input type="hidden" name="request_id" value="<?php echo $request['id']; ?>">
                                <input type="hidden" name="return_url" value="/friends?tab=pending">
                                <button type="submit" class="btn btn-primary btn-sm">Accept</button>
                            </form>
                            <form method="post" class="inline-form">
                                <input type="hidden" name="csrf_token" value="<?php echo e(getCsrfToken()); ?>">
                                <input type="hidden" name="friend_action" value="decline_request">
                                <input type="hidden" name="request_id" value="<?php echo $request['id']; ?>">
                                <input type="hidden" name="return_url" value="/friends?tab=pending">
                                <button type="submit" class="btn btn-outline btn-sm">Decline</button>
                            </form>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>

    <?php elseif ($tab === 'sent'): ?>
        <div class="friends-section">
            <h2 class="friends-section-title">Sent Friend Requests</h2>
            <?php if (empty($sentRequests)): ?>
                <div class="friends-empty">
                    <p>No pending sent requests.</p>
                </div>
            <?php else: ?>
                <div class="friends-grid">
                    <?php foreach ($sentRequests as $request): ?>
                    <div class="friend-card">
                        <a href="/@<?php echo e($request['nickname']); ?>" class="friend-card-photo-link">
                            <?php if (!empty($request['profile_photo'])): ?>
                                <img src="<?php echo e(toPublicFilePath($request['profile_photo'])); ?>" alt="" class="friend-card-photo">
                            <?php else: ?>
                                <div class="friend-card-photo-placeholder">
                                    <?php echo strtoupper(substr($request['display_name'] ?? $request['nickname'] ?? '?', 0, 1)); ?>
                                </div>
                            <?php endif; ?>
                        </a>
                        <div class="friend-card-info">
                            <a href="/@<?php echo e($request['nickname']); ?>" class="friend-card-name">
                                <?php echo e($request['display_name'] ?: $request['nickname']); ?>
                            </a>
                            <span class="friend-card-nickname">@<?php echo e($request['nickname']); ?></span>
                            <span class="friend-card-date">Sent <?php echo date('M j', strtotime($request['created_at'])); ?></span>
                        </div>
                        <div class="friend-card-actions">
                            <span class="friend-status-badge pending">Awaiting response</span>
                            <form method="post" class="inline-form">
                                <input type="hidden" name="csrf_token" value="<?php echo e(getCsrfToken()); ?>">
                                <input type="hidden" name="friend_action" value="cancel_request">
                                <input type="hidden" name="request_id" value="<?php echo $request['id']; ?>">
                                <input type="hidden" name="return_url" value="/friends?tab=sent">
                                <button type="submit" class="btn btn-outline btn-sm">Cancel</button>
                            </form>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>

    <?php elseif ($tab === 'blocked'): ?>
        <div class="friends-section">
            <h2 class="friends-section-title">Blocked Users</h2>
            <?php if (empty($blockedUsers)): ?>
                <div class="friends-empty">
                    <p>You haven't blocked anyone.</p>
                </div>
            <?php else: ?>
                <div class="friends-grid">
                    <?php foreach ($blockedUsers as $blocked): ?>
                    <div class="friend-card friend-card-blocked">
                        <div class="friend-card-photo-link">
                            <?php if (!empty($blocked['profile_photo'])): ?>
                                <img src="<?php echo e(toPublicFilePath($blocked['profile_photo'])); ?>" alt="" class="friend-card-photo">
                            <?php else: ?>
                                <div class="friend-card-photo-placeholder">
                                    <?php echo strtoupper(substr($blocked['display_name'] ?? $blocked['nickname'] ?? '?', 0, 1)); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="friend-card-info">
                            <span class="friend-card-name"><?php echo e($blocked['display_name'] ?: $blocked['nickname']); ?></span>
                            <span class="friend-card-nickname">@<?php echo e($blocked['nickname']); ?></span>
                            <span class="friend-card-date">Blocked <?php echo date('M j, Y', strtotime($blocked['blocked_at'])); ?></span>
                        </div>
                        <div class="friend-card-actions">
                            <form method="post" class="inline-form">
                                <input type="hidden" name="csrf_token" value="<?php echo e(getCsrfToken()); ?>">
                                <input type="hidden" name="friend_action" value="unblock_user">
                                <input type="hidden" name="target_user_id" value="<?php echo $blocked['id']; ?>">
                                <input type="hidden" name="return_url" value="/friends?tab=blocked">
                                <button type="submit" class="btn btn-outline btn-sm">Unblock</button>
                            </form>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    <?php endif; ?>
</div>
