<?php
use NewSite\Cleanup\MissingUploadsService;
use NewSite\Contact\ContactService;

$dmcaContent = $page['content'] ?? '';
$dmcaContactEmail = trim((string)ContactService::getEmail());
if ($dmcaContactEmail !== '' && filter_var($dmcaContactEmail, FILTER_VALIDATE_EMAIL)) {
    $safeDmcaEmail = e($dmcaContactEmail);
    $dmcaEmailHtml = '<a href="mailto:' . $safeDmcaEmail . '">' . $safeDmcaEmail . '</a>';
    $dmcaContent = str_replace(
        ['dmca@yourdomain.com (update this address)', 'dmca@yourdomain.com', '{CONTACT_EMAIL}'],
        $dmcaEmailHtml,
        $dmcaContent
    );
}
$cleanDmcaContent = MissingUploadsService::stripFromHtml($dmcaContent);
if ($cleanDmcaContent !== $dmcaContent && !empty($page['id'])) {
    $stmt = $db->prepare("UPDATE pages SET content = ? WHERE id = ?");
    $stmt->execute([$cleanDmcaContent, $page['id']]);
    $dmcaContent = $cleanDmcaContent;
}
$dmcaTimeValue = (int)($_SESSION['dmca_form_time'] ?? time());
$dmcaNonceValue = (string)($_SESSION['dmca_form_nonce'] ?? '');
?>
<section class="contact-section">
    <div class="container">
        <div class="contact-card">
            <div class="contact-header">
                <h1><?php echo e($page['title'] ?? 'DMCA'); ?></h1>
                <p>Submit a DMCA takedown request using the form below.</p>
            </div>

            <?php if (!empty($dmcaVerifyMessage)): ?>
            <div class="contact-alert contact-alert-success">
                <span><?php echo e($dmcaVerifyMessage); ?></span>
            </div>
            <?php endif; ?>

            <?php if (!empty($dmcaVerifyError)): ?>
            <div class="contact-alert contact-alert-error">
                <span><?php echo e($dmcaVerifyError); ?></span>
            </div>
            <?php endif; ?>

            <?php if ($dmcaSuccess): ?>
            <div class="contact-alert contact-alert-success">
                <span><?php echo e($dmcaSuccess); ?></span>
            </div>
            <?php endif; ?>

            <?php if ($dmcaError): ?>
            <div class="contact-alert contact-alert-error">
                <span><?php echo e($dmcaError); ?></span>
            </div>
            <?php endif; ?>

            <?php if (!empty($dmcaContent)): ?>
            <div class="page-content">
                <?php echo $dmcaContent; ?>
            </div>
            <?php endif; ?>

            <form method="POST" class="contact-form" autocomplete="on">
                <input type="hidden" name="csrf_token" value="<?php echo e(getCsrfToken()); ?>">
                <input type="hidden" name="dmca_time" value="<?php echo (int)$dmcaTimeValue; ?>">
                <input type="hidden" name="dmca_nonce" value="<?php echo e($dmcaNonceValue); ?>">

                <div class="contact-grid">
                    <div class="form-group">
                        <label for="dmca_name">Full Legal Name</label>
                        <input type="text" id="dmca_name" name="name" class="form-control" value="<?php echo e($dmcaForm['name']); ?>" required autocomplete="name">
                    </div>
                    <div class="form-group">
                        <label for="dmca_email">Email Address</label>
                        <input type="email" id="dmca_email" name="email" class="form-control" value="<?php echo e($dmcaForm['email']); ?>" required autocomplete="email">
                    </div>
                </div>

                <div class="form-group">
                    <label for="dmca_address">Address</label>
                    <textarea id="dmca_address" name="address" class="form-control" rows="2" required><?php echo e($dmcaForm['address']); ?></textarea>
                </div>

                <div class="form-group">
                    <label for="dmca_phone">Phone (optional)</label>
                    <input type="text" id="dmca_phone" name="phone" class="form-control" value="<?php echo e($dmcaForm['phone']); ?>" autocomplete="tel">
                </div>

                <div class="form-group">
                    <label for="dmca_work">Description of Copyrighted Work</label>
                    <textarea id="dmca_work" name="work_description" class="form-control" rows="4" required><?php echo e($dmcaForm['work_description']); ?></textarea>
                </div>

                <div class="form-group">
                    <label for="dmca_urls">Infringing URL(s) (one per line)</label>
                    <textarea id="dmca_urls" name="infringing_urls" class="form-control" rows="5" required><?php echo e($dmcaForm['infringing_urls']); ?></textarea>
                </div>

                <div class="form-group">
                    <label for="dmca_signature">Signature (type your full name)</label>
                    <input type="text" id="dmca_signature" name="signature" class="form-control" value="<?php echo e($dmcaForm['signature']); ?>" required>
                </div>

                <div class="form-group">
                    <label>
                        <input type="checkbox" name="good_faith" required>
                        I have a good-faith belief that the use of the material is not authorized.
                    </label>
                </div>

                <div class="form-group">
                    <label>
                        <input type="checkbox" name="perjury" required>
                        I swear, under penalty of perjury, that the information in this notice is accurate.
                    </label>
                </div>

                <div class="form-group">
                    <label>
                        <input type="checkbox" name="authorized" required>
                        I am the copyright owner or authorized to act on the owner's behalf.
                    </label>
                </div>

                <div class="is-hidden">
                    <input type="text" name="website" tabindex="-1" autocomplete="off">
                </div>

                <div class="contact-actions">
                    <button type="submit" class="btn btn-primary">Submit DMCA Request</button>
                </div>
            </form>
        </div>
    </div>
</section>
