<?php
/**
 * Built-in Contact Page
 */
?>
<section class="contact-section">
    <div class="container">
        <div class="contact-card">
            <div class="contact-header">
                <h1>Contact</h1>
                <p>Send me a message and I will get back to you.</p>
                <?php if (!empty($contactEmail)): ?>
                <p class="contact-email">Email: <a href="mailto:<?php echo e($contactEmail); ?>"><?php echo e($contactEmail); ?></a></p>
                <?php endif; ?>
            </div>

            <?php if ($contactSuccess): ?>
            <div class="contact-alert contact-alert-success">
                <span><?php echo e($contactSuccess); ?></span>
            </div>
            <?php endif; ?>

            <?php if ($contactError): ?>
            <div class="contact-alert contact-alert-error">
                <span><?php echo e($contactError); ?></span>
            </div>
            <?php endif; ?>

            <form method="POST" class="contact-form" enctype="multipart/form-data">
                <div class="contact-grid">
                    <div class="form-group">
                        <label for="contact_name">Your Name</label>
                        <input type="text" id="contact_name" name="name" class="form-control" value="<?php echo e($contactForm['name']); ?>" required autocomplete="name">
                    </div>
                    <div class="form-group">
                        <label for="contact_email">Email Address</label>
                        <input type="email" id="contact_email" name="email" class="form-control" value="<?php echo e($contactForm['email']); ?>" required autocomplete="email">
                    </div>
                </div>

                <div class="form-group">
                    <label for="contact_subject">Subject</label>
                    <input type="text" id="contact_subject" name="subject" class="form-control" value="<?php echo e($contactForm['subject']); ?>" placeholder="<?php echo e($contactSubjectDefault); ?>">
                </div>

                <div class="form-group">
                    <label for="contact_attachment">Attachment (Image Only)</label>
                    <input type="file" id="contact_attachment" name="attachment" class="form-control" accept="image/png, image/jpeg, image/webp">
                    <small class="text-muted">Max 5MB. JPG, PNG, WEBP only.</small>
                </div>

                <div class="form-group">
                    <label for="contact_message">Message</label>
                    <textarea id="contact_message" name="message" class="form-control" rows="6" required><?php echo e($contactForm['message']); ?></textarea>
                </div>

                <div class="is-hidden">
                    <input type="text" name="website" tabindex="-1" autocomplete="off">
                </div>

                <div class="contact-actions">
                    <button type="submit" class="btn btn-primary">Send Message to Me</button>
                </div>
            </form>
        </div>
    </div>
</section>
