<?php

use NewSite\Util\CurrencyData;

if (!defined('ROOT_PATH')) {
    http_response_code(403);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: /');
    exit;
}

$currency = strtoupper(trim($_POST['currency'] ?? ''));
$currencyMap = CurrencyData::getMap();

if ($currency !== '' && isset($currencyMap[$currency])) {
    $_SESSION['store_currency'] = $currency;
    $_SESSION['store_currency_symbol'] = $currencyMap[$currency];
}

$redirect = $_SERVER['HTTP_REFERER'] ?? '/';
header('Location: ' . $redirect);
exit;
