<?php

use NewSite\Database\DatabaseManager;

if (!defined('ROOT_PATH')) {
    http_response_code(403);
    exit;
}

header('Content-Type: application/json');

$query = trim($_GET['q'] ?? '');
if ($query === '') {
    echo json_encode(['success' => true, 'items' => []]);
    exit;
}

$like = '%' . $query . '%';
$db = DatabaseManager::getWriteConnection();
$limit = 6;
$stmt = $db->prepare("SELECT p.id, p.name, p.product_slug, pg.slug AS page_slug, pm.media_url AS gallery_media, p.media_url AS media_url FROM products p LEFT JOIN pages pg ON pg.id = p.page_id LEFT JOIN product_media pm ON pm.product_id = p.id AND pm.sort_order = 0 WHERE p.is_active = 1 AND (p.name ILIKE ? OR p.description ILIKE ?) ORDER BY p.updated_at DESC LIMIT " . (int)$limit);
$stmt->execute([$like, $like]);
$items = [];
foreach ($stmt->fetchAll() as $row) {
    $pageSlug = trim($row['page_slug'] ?? '');
    $productSlug = trim((string)($row['product_slug'] ?? ''));
    $mediaUrl = toPublicFilePath(trim($row['gallery_media'] ?? $row['media_url'] ?? ''));
    $productUrl = '';
    if ($pageSlug !== '' && $productSlug !== '') {
        $productUrl = '/' . $pageSlug . '/' . rawurlencode($productSlug);
    } elseif ($pageSlug !== '') {
        $productUrl = '/' . $pageSlug . '?product=' . (int)$row['id'];
    }
    $items[] = [
        'name' => (string)($row['name'] ?? ''),
        'url' => $productUrl,
        'media' => $mediaUrl,
        'type' => 'product',
        'icon' => ''
    ];
}

if (count($items) < $limit) {
    $needle = function_exists('mb_strtolower')
        ? mb_strtolower($query, 'UTF-8')
        : strtolower($query);

    foreach (\NewSite\Minigames\MinigameRepository::getEnabled($db) as $game) {
        $slug = trim((string)($game['slug'] ?? ''));
        $title = trim((string)($game['title'] ?? ''));
        $description = trim((string)($game['description'] ?? ''));
        $icon = trim((string)($game['icon'] ?? ''));

        if ($slug === '' || $title === '') {
            continue;
        }

        $titleNeedle = function_exists('mb_strtolower')
            ? mb_strtolower($title, 'UTF-8')
            : strtolower($title);
        $descriptionNeedle = function_exists('mb_strtolower')
            ? mb_strtolower($description, 'UTF-8')
            : strtolower($description);
        $slugNeedle = function_exists('mb_strtolower')
            ? mb_strtolower($slug, 'UTF-8')
            : strtolower($slug);

        if (
            strpos($titleNeedle, $needle) === false
            && strpos($descriptionNeedle, $needle) === false
            && strpos($slugNeedle, $needle) === false
        ) {
            continue;
        }

        $publicSlug = \NewSite\Minigames\MinigameCatalog::getPublicSlug($slug);
        if ($publicSlug === '') {
            continue;
        }

        $items[] = [
            'name' => $title,
            'url' => '/games/' . $publicSlug,
            'media' => '',
            'type' => 'mini_game',
            'icon' => $icon,
        ];

        if (count($items) >= $limit) {
            break;
        }
    }
}

echo json_encode(['success' => true, 'items' => $items]);
