<?php

use NewSite\Auth\SiteAuth;
use NewSite\Database\DatabaseManager;

/**
 * Notifications API
 * Uses file/Redis caching for scalability (95% reduction in DB queries)
 * Only returns NOTICE messages, not support tickets
 */

if (!defined('ROOT_PATH')) {
    http_response_code(403);
    exit;
}

header('Content-Type: application/json');

if (!SiteAuth::isLoggedIn()) {
    echo json_encode(['success' => false]);
    exit;
}

$userId = (int)($_SESSION['site_user_id'] ?? 0);
$method = strtoupper($_SERVER['REQUEST_METHOD'] ?? 'GET');
$action = $method === 'POST'
    ? (string)($_POST['action'] ?? '')
    : (string)($_GET['action'] ?? '');

if ($action === 'mark_all') {
    if ($method !== 'POST') {
        http_response_code(405);
        echo json_encode(['success' => false, 'error' => 'Method not allowed.']);
        exit;
    }
    $db = DatabaseManager::getWriteConnection();
    // Only mark NOTICE messages as read (not tickets)
    $stmt = $db->prepare("UPDATE user_messages SET is_read = 1 WHERE user_id = ? AND message_type = 'notice'");
    $stmt->execute([$userId]);

    // Invalidate cache after marking as read
    \NewSite\Cache\CachedQueries::invalidateNotificationCache($userId);
}

// Use cached notification data (includes items, counts, friend requests)
$data = \NewSite\Cache\CachedQueries::getNotificationData($userId);

echo json_encode($data);
