<?php

use NewSite\Logging\LogService;

/**
 * Frontend Error Logging API
 * Receives JavaScript/CSS/Resource errors from the browser
 */

if (!defined('ROOT_PATH')) {
    http_response_code(403);
    exit;
}

header('Content-Type: application/json');

// Only accept POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

// Get JSON input
$input = json_decode(file_get_contents('php://input'), true);

if (!$input || empty($input['type'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid request']);
    exit;
}

$type = preg_replace('/[^a-z_]/', '', strtolower($input['type'] ?? 'js_error'));
$message = substr($input['message'] ?? 'Unknown error', 0, 500);
$details = substr($input['details'] ?? '', 0, 2000);

// Add page info
$page = $_SERVER['HTTP_REFERER'] ?? 'unknown';
$details .= "\nPage: $page";
$details .= "\nUA: " . ($_SERVER['HTTP_USER_AGENT'] ?? 'unknown');

// Log it
LogService::add($type, $message, $details);

echo json_encode(['success' => true]);
