<?php

use NewSite\Logging\LogService;
use NewSite\Security\IpService;

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    header('Allow: POST');
    exit;
}

$raw = file_get_contents('php://input');
$payload = json_decode($raw, true);
if (!is_array($payload)) {
    http_response_code(400);
    header('Content-Type: application/json');
    echo json_encode(['error' => 'Invalid payload']);
    exit;
}

$preferences = [
    'necessary' => true,
    'analytics' => !empty($payload['analytics']),
    'marketing' => !empty($payload['marketing']),
    'timestamp' => $payload['timestamp'] ?? gmdate('c')
];

$cookieValue = rawurlencode(json_encode($preferences));
$secure = !empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off';
setcookie('cookie_consent', $cookieValue, [
    'expires' => time() + (365 * 24 * 60 * 60),
    'path' => '/',
    'secure' => $secure,
    'httponly' => false,
    'samesite' => 'Lax'
]);

$details = [
    'preferences' => $preferences,
    'user_id' => (int)($_SESSION['site_user_id'] ?? 0),
    'ip' => IpService::gdprStore($_SERVER['REMOTE_ADDR'] ?? null),
    'user_agent' => substr($_SERVER['HTTP_USER_AGENT'] ?? '', 0, 255)
];
LogService::add('gdpr', 'Cookie consent updated', json_encode($details));

header('Content-Type: application/json');
echo json_encode(['ok' => true]);
