<?php
use NewSite\Auth\SiteAuth;
use NewSite\User\UserService;

SiteAuth::requireLogin();
$user = UserService::getById((int)($_SESSION['site_user_id'] ?? 0));
$email = $user['email'] ?? '';
$createdAt = !empty($user['created_at']) ? date('F j, Y', (int)$user['created_at']) : '';
$lastLogin = !empty($user['last_login_at']) ? date('F j, Y g:i A', (int)$user['last_login_at']) : '';
?>

<section class="auth-section">
    <div class="container">
        <div class="auth-card">
            <h1>Account Settings</h1>
            <p class="auth-subtitle">Manage your account details.</p>

            <div class="account-tabs">
                <a href="/messages" class="account-tab">Message Center</a>
                <a href="/account-settings" class="account-tab active">Account Settings</a>
            </div>

            <div class="account-info">
                <div>
                    <span class="account-label">Email</span>
                    <span class="account-value"><?php echo e($email); ?></span>
                </div>
                <?php if ($createdAt): ?>
                <div>
                    <span class="account-label">Member since</span>
                    <span class="account-value"><?php echo e($createdAt); ?></span>
                </div>
                <?php endif; ?>
                <?php if ($lastLogin): ?>
                <div>
                    <span class="account-label">Last login</span>
                    <span class="account-value"><?php echo e($lastLogin); ?></span>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>
