<?php

use NewSite\Auth\AdminAuth;
use NewSite\Upload\ImageUrlHelper;
use NewSite\Database\DatabaseManager;

if (!defined('ROOT_PATH')) {
    http_response_code(403);
    exit;
}

AdminAuth::requireLogin();

header('Content-Type: application/json');

$userId = (int)($_GET['user_id'] ?? 0);
if ($userId <= 0) {
    echo json_encode(['success' => false, 'error' => 'Invalid user']);
    exit;
}

$db = DatabaseManager::getWriteConnection();

// Mark user messages as read by admin when fetching (live updates)
$stmt = $db->prepare("UPDATE user_messages SET admin_read = 1 WHERE user_id = ? AND message_type = 'ticket' AND sender_type = 'user' AND (admin_read = 0 OR admin_read IS NULL)");
$stmt->execute([$userId]);

$stmt = $db->prepare("SELECT um.*, su.email FROM user_messages um JOIN site_users su ON su.id = um.user_id WHERE um.user_id = ? AND um.message_type = 'ticket' ORDER BY um.created_at DESC LIMIT 200");
$stmt->execute([$userId]);
$items = $stmt->fetchAll();

$payload = [];
foreach ($items as $item) {
    $imagePath = $item['image_path'] ?? null;
    $payload[] = [
        'id' => (int)$item['id'],
        'body' => $item['body'] ?? '',
        'sender_type' => $item['sender_type'] ?? 'admin',
        'created_at' => !empty($item['created_at']) ? (int)$item['created_at'] : 0,
        'email' => $item['email'] ?? '',
        'image_path' => $imagePath,
        'image_url' => $imagePath ? ImageUrlHelper::getChatImageUrl($imagePath) : null,
        'admin_read' => !empty($item['admin_read']),
        'is_read' => !empty($item['is_read'])
    ];
}

echo json_encode([
    'success' => true,
    'items' => $payload
]);
