<?php

/**
 * Admin Logout
 */

use NewSite\Auth\AdminAuth;
use NewSite\Logging\LogService;

if (!defined('ROOT_PATH')) {
    http_response_code(403);
    exit;
}

// Block access if IP is not allowed
AdminAuth::requireIp();

// Log logout before destroying session
$adminUser = $_SESSION['admin_username'] ?? 'unknown';
$adminId = $_SESSION['admin_user_id'] ?? null;
LogService::add('admin_logout', "Admin logout: $adminUser", "User ID: $adminId");

session_destroy();
header('Location: /admin/login.php');
exit;
