<?php
/**
 * Admin Panel - Login Page
 */

use NewSite\Auth\AdminAuth;
use NewSite\Database\DatabaseManager;
use NewSite\Logging\LogService;

if (!defined('ROOT_PATH')) {
    http_response_code(403);
    exit;
}

// Block access if IP is not allowed
AdminAuth::requireIp();

// Redirect if already logged in
if (AdminAuth::isLoggedIn()) {
    header('Location: /admin/');
    exit;
}

$error = '';

// Handle login
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';

    if (empty($username) || empty($password)) {
        $error = 'Please enter username and password.';
    } else {
        $db = DatabaseManager::getWriteConnection();
        $stmt = $db->prepare("SELECT * FROM users WHERE username = ? AND role = 'admin'");
        $stmt->execute([$username]);
        $user = $stmt->fetch();

        if ($user && password_verify($password, $user['password'])) {
            $_SESSION['admin_logged_in'] = true;
            $_SESSION['admin_user_id'] = $user['id'];
            $_SESSION['admin_username'] = $user['username'];
            LogService::add('admin_login', "Admin login: {$user['username']}", "User ID: {$user['id']}");
            header('Location: /admin/');
            exit;
        } else {
            LogService::add('security', 'Failed admin login attempt', json_encode(['username' => $username, 'ip' => $_SERVER['REMOTE_ADDR'] ?? 'unknown']));
            $error = 'Invalid username or password.';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(getCsrfToken()); ?>">
    <title>Admin Login</title>
    <link rel="stylesheet" href="/admin/assets/css/admin.css">
</head>
<body class="login-page">
    <div class="login-container">
        <div class="login-box">
            <div class="login-header">
                <h1>Admin Panel</h1>
                <p>Enter your credentials to continue</p>
            </div>

            <?php if ($error): ?>
            <div class="alert alert-error"><?php echo e($error); ?></div>
            <?php endif; ?>

            <form method="POST" action="" class="login-form">
                <input type="hidden" name="csrf_token" value="<?php echo e(getCsrfToken()); ?>">
                <div class="form-group">
                    <label for="username">Username</label>
                    <input type="text" id="username" name="username" required autofocus autocomplete="username">
                </div>

                <div class="form-group">
                    <label for="password">Password</label>
                    <input type="password" id="password" name="password" required autocomplete="current-password">
                </div>

                <button type="submit" class="btn btn-primary btn-block">Login</button>
            </form>

            <div class="login-footer">
                <a href="/">← Back to website</a>
            </div>
        </div>
    </div>
</body>
</html>
