<?php
/**
 * Admin Panel - Legal Pages
 */

if (!defined('ROOT_PATH')) {
    http_response_code(403);
    exit;
}

use NewSite\Auth\AdminAuth;
use NewSite\Template\ContentRenderer;
use NewSite\Admin\AdminLayout;
use NewSite\Database\DatabaseManager;

AdminAuth::requireLogin();

$db = DatabaseManager::getWriteConnection();
$message = $_GET['message'] ?? '';
$error = $_GET['error'] ?? '';

const PAGE_TITLE_PRIVACY_POLICY = 'Privacy Policy';
const PAGE_TITLE_TERMS_OF_SERVICE = 'Terms of Service';
const PAGE_TITLE_REFUND_POLICY = 'Refund Policy';
const PAGE_TITLE_SHIPPING_POLICY = 'Shipping Policy';
const PAGE_TITLE_LEGAL_NOTICE = 'Legal Notice';

const SQL_UPDATE_PAGE_CONTENT_META_BY_ID = "UPDATE pages SET content = ?, meta_title = ?, meta_description = ? WHERE id = ?";

// -----------------------------------------------------------------------------
// Legal template migration snapshots
// -----------------------------------------------------------------------------
// The $legacy* and $previous* template variables below are historical defaults
// kept only for safe one-time auto-update checks.
// They are NOT shown to visitors unless that exact content is already stored in
// the database for a page. Current visible defaults come from $default* values.
// -----------------------------------------------------------------------------

// Snapshot set: legacy + previous + current default
$legacyPrivacyContent = <<<'HTML'
<h2>Privacy Policy</h2>
<p>Last Updated: February 5, 2026</p>
<p>{SITE_NAME} ("we", "us", "our") operates {SITE_URL}. This Privacy Policy explains how we collect, use, and share information when you use our website, create an account, or purchase products.</p>

<h3>Information We Collect</h3>
<ul>
    <li>Account and profile information: email, display name, nickname, and any optional profile details you provide.</li>
    <li>Login and security data: when you request a login link, we process your email and may log IP address and device/browser details to prevent abuse.</li>
    <li>User-generated content: posts, comments, images, and messages you submit to the forum or public areas.</li>
    <li>Orders and customer support: purchase history, digital download access, and support requests.</li>
    <li>Payment processing: payments are handled by Stripe. We do not store full card numbers.</li>
    <li>Future physical orders: shipping address and delivery details if you buy physical products.</li>
    <li>Technical and usage data: IP address, device and browser details, and security logs.</li>
    <li>Cookies and local storage: session, security, and cookie consent preferences.</li>
</ul>

<h3>How We Use Information</h3>
<ul>
    <li>Provide and maintain the site, accounts, and digital downloads.</li>
    <li>Process orders and deliver products.</li>
    <li>Moderate content and enforce our Terms of Service.</li>
    <li>Protect the site against fraud and abuse.</li>
    <li>Respond to support and legal requests.</li>
    <li>Improve performance and user experience.</li>
</ul>

<h3>Legal Bases (GDPR)</h3>
<p>We process personal data based on consent, contract performance, legitimate interests, and legal obligations.</p>

<h3>Sharing and Disclosure</h3>
<ul>
    <li>Service providers (hosting, email, analytics, payment processing).</li>
    <li>Legal and safety requirements.</li>
    <li>Business transfers if we restructure the business.</li>
</ul>

<h3>International Transfers</h3>
<p>We may process data in countries other than yours. We use appropriate safeguards when required.</p>

<h3>User Content and Public Areas</h3>
<p>Forum posts, public profiles, and uploaded images may be visible to other visitors. Do not upload sensitive personal data. We may keep backups for a limited time after content is removed.</p>

<h3>Sensitive Information</h3>
<p>We do not request sensitive personal data (such as government IDs, health data, precise location, or biometrics). If you choose to post or upload sensitive information, you do so at your own risk and you consent to our processing of that information for the purpose of providing, moderating, and securing the service.</p>

<h3>Data Retention</h3>
<p>We keep data only as long as needed for the purposes described, and per our retention settings. Logs and rate-limit data are automatically purged on a schedule.</p>

<h3>Your Rights</h3>
<p>You may request access, correction, deletion, or export of your data, and object to certain processing. Contact us at {CONTACT_EMAIL}.</p>

<h3>Regional Privacy Rights</h3>
<ul>
    <li><strong>EEA/UK (GDPR):</strong> access, correction, deletion, portability, restriction, objection, and the right to lodge a complaint with a supervisory authority.</li>
    <li><strong>California and other US states:</strong> right to know, delete, and correct personal data, and to opt out of selling or sharing personal data for targeted advertising. We do not sell personal data.</li>
    <li><strong>Brazil (LGPD):</strong> confirmation of processing, access, correction, deletion, portability, and information about sharing.</li>
    <li><strong>Canada (PIPEDA):</strong> access, correction, and the right to challenge compliance with privacy obligations.</li>
    <li><strong>Other regions:</strong> you may have similar rights under local law. Contact us to exercise your rights.</li>
</ul>

<h3>Children</h3>
<p>The site is not intended for children under the age required by local law.</p>

<h3>Contact</h3>
<p>Questions about this policy can be sent to {CONTACT_EMAIL}.</p>
HTML;

$previousPrivacyContent = <<<'HTML'
<h2>Privacy Policy</h2>
<p>Last Updated: February 5, 2026</p>
<p>{SITE_NAME} ("we", "us", "our") operates {SITE_URL}. This Privacy Policy explains how we collect, use, and share information when you use our website, create an account, or purchase products.</p>

<h3>Information We Collect</h3>
<ul>
    <li>Account and profile information: email, display name, nickname, and any optional profile details you provide.</li>
    <li>Login and security data: when you request a login link, we process your email and may log IP address and device/browser details to prevent abuse.</li>
    <li>User-generated content: posts, comments, images, and messages you submit to the forum or public areas.</li>
    <li>Orders and customer support: purchase history, digital download access, and support requests.</li>
    <li>Payment processing: payments are handled by Stripe. We do not store full card numbers.</li>
    <li>Future physical orders: shipping address and delivery details if you buy physical products.</li>
    <li>Technical and usage data: IP address, device and browser details, and security logs.</li>
    <li>Cookies and local storage: session, security, and cookie consent preferences.</li>
</ul>

<h3>How We Use Information</h3>
<ul>
    <li>Provide and maintain the site, accounts, and digital downloads.</li>
    <li>Process orders and deliver products.</li>
    <li>Moderate content and enforce our Terms of Service.</li>
    <li>Protect the site against fraud and abuse.</li>
    <li>Respond to support and legal requests.</li>
    <li>Improve performance and user experience.</li>
</ul>

<h3>Legal Bases (GDPR)</h3>
<p>We process personal data based on consent, contract performance, legitimate interests, and legal obligations.</p>

<h3>Sharing and Disclosure</h3>
<ul>
    <li>Service providers (hosting, email, analytics, payment processing).</li>
    <li>Legal and safety requirements.</li>
    <li>Business transfers if we restructure the business.</li>
</ul>

<h3>International Transfers</h3>
<p>We may process data in countries other than yours. We use appropriate safeguards when required.</p>

<h3>Data Retention</h3>
<p>We keep data only as long as needed for the purposes described, and per our retention settings. Logs and rate-limit data are automatically purged on a schedule.</p>

<h3>Your Rights</h3>
<p>You may request access, correction, deletion, or export of your data, and object to certain processing. Contact us at {CONTACT_EMAIL}.</p>

<h3>Children</h3>
<p>The site is not intended for children under the age required by local law.</p>

<h3>Contact</h3>
<ul>
    <li>Name: {CONTACT_NAME}</li>
    <li>Email: {CONTACT_EMAIL}</li>
    <li>Phone: {CONTACT_PHONE}</li>
    <li>Address: {CONTACT_ADDRESS}</li>
</ul>
HTML;

$defaultPrivacyContent = <<<'HTML'
<h2>Privacy Policy</h2>
<p>Last Updated: February 18, 2026</p>
<p>{SITE_NAME} ("we", "us", "our") operates {SITE_URL}. This Privacy Policy explains how we collect, use, and share information when you use our website, create an account, participate in community features, and buy products.</p>

<h3>Information We Collect</h3>
<ul>
    <li>Account and profile data (email, display name, nickname, optional profile fields).</li>
    <li>Authentication and security data (login-link requests, security logs, abuse-prevention metadata).</li>
    <li>Community/forum content (posts, comments, media uploads, moderation metadata).</li>
    <li>Orders and fulfillment data (order history, downloadable access, shipping details for physical goods).</li>
    <li>Technical data (IP-derived security controls, browser/device details, cookie preferences).</li>
    <li>Support and legal communications you send to us.</li>
</ul>

<h3>Product Types and Fulfillment</h3>
<ul>
    <li><strong>Cart/Checkout products:</strong> payment and order details are processed to complete purchases.</li>
    <li><strong>Digital download products:</strong> we store delivery/access information and download activity for fraud prevention and support.</li>
    <li><strong>External-link products:</strong> you may be redirected to a third-party destination with its own privacy terms.</li>
    <li><strong>Physical products:</strong> we process delivery details required for shipping and order support.</li>
</ul>

<h3>How We Use Data</h3>
<ul>
    <li>Provide and secure accounts, community features, purchases, and support.</li>
    <li>Moderate abuse and enforce Terms of Service.</li>
    <li>Process transactions and fulfill digital/physical products.</li>
    <li>Handle legal requests and regulatory obligations.</li>
    <li>Improve service performance, reliability, and user experience.</li>
</ul>

<h3>Legal Bases (GDPR)</h3>
<p>We process data based on consent, contract performance, legitimate interests, and legal obligations.</p>

<h3>Sharing and Disclosure</h3>
<ul>
    <li>Payment, hosting, email, delivery, and infrastructure providers.</li>
    <li>Authorities/law-enforcement when required by law.</li>
    <li>Professional advisers and successors in a lawful business transfer.</li>
</ul>

<h3>International Transfers</h3>
<p>Your information may be processed in countries outside your own. Where required, we apply appropriate safeguards.</p>

<h3>Your Rights</h3>
<p>Depending on your region, you may have rights to access, correct, delete, restrict, object, or port your data, and to lodge complaints with a supervisory authority.</p>

<h3>Regional Privacy Notes</h3>
<ul>
    <li><strong>EEA/UK:</strong> GDPR/UK-GDPR rights apply.</li>
    <li><strong>US States:</strong> rights may include access, correction, deletion, and appeal under local law.</li>
    <li><strong>Brazil/Canada/other regions:</strong> equivalent statutory rights apply where required.</li>
</ul>

<h3>Retention</h3>
<p>We retain data only as needed for service operation, fraud prevention, support, and legal compliance, then delete or anonymize it according to configured retention periods.</p>

<h3>Children</h3>
<p>The service is not intended for children under the minimum age required by local law.</p>

<h3>Contact</h3>
<ul>
    <li>Name: {CONTACT_NAME}</li>
    <li>Email: {CONTACT_EMAIL}</li>
    <li>Phone: {CONTACT_PHONE}</li>
    <li>Address: {CONTACT_ADDRESS}</li>
</ul>
HTML;

$previousPrivacyContentV2 = $defaultPrivacyContent;
// Apply updated wording while preserving the immediately previous default
// snapshot above for migration matching.
$defaultPrivacyContent = str_replace(
    '<li>Professional advisers and successors in a lawful business transfer.</li>',
    '<li>We do not sell personal data and do not share personal data with advertising networks, data brokers, or professional advertisers.</li>',
    $defaultPrivacyContent
);
$defaultPrivacyContent = str_replace(
    '<li><strong>US States:</strong> rights may include access, correction, deletion, and appeal under local law.</li>',
    '<li><strong>US States:</strong> rights may include access, correction, deletion, and appeal under local law. We do not sell personal data or share it for targeted advertising.</li>',
    $defaultPrivacyContent
);

// Snapshot set: legacy + previous + current default
$legacyTermsContent = <<<'HTML'
<h2>Terms of Service</h2>
<p>Last Updated: February 5, 2026</p>
<p>Welcome to {SITE_NAME}. By using {SITE_URL}, you agree to these Terms of Service.</p>

<h3>1. Accounts and Eligibility</h3>
<p>You are responsible for your account and any activity that occurs under it. You must provide accurate information and keep your login link secure. Authentication uses time-limited login links sent by email. By requesting a login link or using the site, you agree to these Terms and our Privacy Policy.</p>

<h3>2. User Content and License</h3>
<p>You retain ownership of the content you post. By submitting content (including images) to forums or public areas, you grant us a worldwide, non-exclusive, royalty-free license to host, store, display, reproduce, and distribute your content solely for operating and promoting the service. You represent that you have the rights to share the content.</p>

<h3>3. Prohibited Conduct</h3>
<ul>
    <li>Do not post content that is illegal, infringing, abusive, or harmful.</li>
    <li>Do not upload malware or attempt to compromise site security.</li>
    <li>Do not misuse the platform or harass other users.</li>
</ul>

<h3>4. Digital Products</h3>
<p>Digital products are licensed, not sold. You may use them for personal, non-commercial purposes unless otherwise stated. Redistribution or resale is prohibited.</p>

<h3>5. Physical Products (Future)</h3>
<p>If we offer physical products, shipping and returns will be governed by our Shipping Policy and Refund Policy.</p>

<h3>6. Payments and Refunds</h3>
<p>Prices and taxes are shown at checkout. Refunds and returns follow our Refund Policy and applicable law.</p>

<h3>7. Intellectual Property and DMCA</h3>
<p>All site content and branding are protected by intellectual property laws. Our DMCA policy is available at /dmca.</p>

<h3>8. Third-Party Links</h3>
<p>We may link to third-party platforms (e.g., Steam, Epic Games). We are not responsible for their content or policies.</p>

<h3>9. Disclaimers</h3>
<p>The service is provided "as is" without warranties of any kind.</p>

<h3>10. Limitation of Liability</h3>
<p>To the maximum extent permitted by law, we are not liable for indirect or consequential damages arising from your use of the site.</p>

<h3>11. Changes</h3>
<p>We may update these terms from time to time. Continued use of the site means you accept the updated terms.</p>

<h3>12. Contact</h3>
<p>If you have questions about these Terms, contact us at {CONTACT_EMAIL}.</p>
HTML;

$previousTermsContent = <<<'HTML'
<h2>Terms of Service</h2>
<p>Last Updated: February 5, 2026</p>
<p>Welcome to {SITE_NAME}. By using {SITE_URL}, you agree to these Terms of Service.</p>

<h3>1. Accounts and Eligibility</h3>
<p>You are responsible for your account and any activity that occurs under it. You must provide accurate information and keep your login link secure. Authentication uses time-limited login links sent by email. By requesting a login link or using the site, you agree to these Terms and our Privacy Policy.</p>

<h3>2. User Content and License</h3>
<p>You retain ownership of the content you post. By submitting content (including images) to forums or public areas, you grant us a worldwide, non-exclusive, royalty-free license to host, store, display, reproduce, and distribute your content solely for operating and promoting the service. You represent that you have the rights to share the content.</p>

<h3>3. Prohibited Conduct</h3>
<ul>
    <li>Do not post content that is illegal, infringing, abusive, or harmful.</li>
    <li>Do not upload malware or attempt to compromise site security.</li>
    <li>Do not misuse the platform or harass other users.</li>
</ul>

<h3>4. Digital Products</h3>
<p>Digital products are licensed, not sold. You may use them for personal, non-commercial purposes unless otherwise stated. Redistribution or resale is prohibited.</p>

<h3>5. Physical Products (Future)</h3>
<p>If we offer physical products, shipping and returns will be governed by our Shipping Policy and Refund Policy.</p>

<h3>6. Payments and Refunds</h3>
<p>Prices and taxes are shown at checkout. Refunds and returns follow our Refund Policy and applicable law.</p>

<h3>7. Intellectual Property and DMCA</h3>
<p>All site content and branding are protected by intellectual property laws. Our DMCA policy is available at /dmca.</p>

<h3>8. Third-Party Links</h3>
<p>We may link to third-party platforms (e.g., Steam, Epic Games). We are not responsible for their content or policies.</p>

<h3>9. Disclaimers</h3>
<p>The service is provided "as is" without warranties of any kind.</p>

<h3>10. Limitation of Liability</h3>
<p>To the maximum extent permitted by law, we are not liable for indirect or consequential damages arising from your use of the site.</p>

<h3>11. Changes</h3>
<p>We may update these terms from time to time. Continued use of the site means you accept the updated terms.</p>

<h3>12. Contact</h3>
<ul>
    <li>Name: {CONTACT_NAME}</li>
    <li>Email: {CONTACT_EMAIL}</li>
    <li>Phone: {CONTACT_PHONE}</li>
    <li>Address: {CONTACT_ADDRESS}</li>
</ul>
HTML;

$defaultTermsContent = <<<'HTML'
<h2>Terms of Service</h2>
<p>Last Updated: February 18, 2026</p>
<p>Welcome to {SITE_NAME}. By using {SITE_URL}, you agree to these Terms of Service.</p>

<h3>1. Accounts and Access</h3>
<p>You are responsible for activity on your account and for keeping account access secure. You must provide accurate information and comply with applicable law.</p>

<h3>2. Community Features (Forum, Profiles, Messages)</h3>
<p>You retain ownership of content you submit. By posting content, you grant us a non-exclusive license to host, display, and process it for service operation, moderation, security, and lawful enforcement.</p>

<h3>3. Prohibited Use</h3>
<ul>
    <li>No illegal, infringing, abusive, deceptive, or malicious activity.</li>
    <li>No malware, scraping abuse, credential abuse, or attempts to bypass security controls.</li>
    <li>No harassment, impersonation, or rights violations.</li>
</ul>

<h3>4. Product Types and Fulfillment</h3>
<ul>
    <li><strong>Cart/Checkout products:</strong> purchased directly on this site.</li>
    <li><strong>Digital downloads:</strong> licensed (not sold), subject to license restrictions and anti-abuse controls.</li>
    <li><strong>External-link products:</strong> may redirect you to third-party stores/platforms with their own terms.</li>
    <li><strong>Physical products:</strong> shipping and return conditions apply where offered.</li>
</ul>

<h3>5. Pricing, Taxes, and Payment</h3>
<p>Prices, taxes, and applicable fees are displayed at checkout where required. Payment processing providers handle payment authorization and settlement.</p>

<h3>6. Refunds, Returns, and Withdrawal Rights</h3>
<p>Refunds and returns follow our Refund Policy and mandatory local consumer law. Nothing in these terms limits statutory consumer rights.</p>

<h3>7. Third-Party Services and External Links</h3>
<p>Third-party destinations, stores, and services are outside our control. Their terms and privacy policies govern your use of those services.</p>

<h3>8. Intellectual Property and Takedowns</h3>
<p>Site content and branding are protected by intellectual property laws. Copyright claims may be submitted under our DMCA policy.</p>

<h3>9. Service Changes and Availability</h3>
<p>We may modify, suspend, or discontinue parts of the service for maintenance, legal compliance, abuse prevention, or product updates.</p>

<h3>10. Suspension and Termination</h3>
<p>We may suspend or terminate access for violations of these terms, abuse, fraud, or legal requirements.</p>

<h3>11. Disclaimer</h3>
<p>The service is provided "as is" and "as available" to the extent permitted by law.</p>

<h3>12. Limitation of Liability</h3>
<p>To the maximum extent permitted by law, we are not liable for indirect, incidental, special, or consequential damages.</p>

<h3>13. Local Law and Consumer Protection</h3>
<p>Mandatory rights under your local law remain unaffected.</p>

<h3>14. Contact</h3>
<ul>
    <li>Name: {CONTACT_NAME}</li>
    <li>Email: {CONTACT_EMAIL}</li>
    <li>Phone: {CONTACT_PHONE}</li>
    <li>Address: {CONTACT_ADDRESS}</li>
</ul>
HTML;

// Snapshot set: legacy + previous + previous V2 + current default
$legacyRefundContent = <<<'HTML'
<h2>Refund and Return Policy</h2>
<p>Last Updated: February 5, 2026</p>
<p>This policy applies to purchases made through {SITE_NAME}.</p>

<h3>Digital Products</h3>
<p>Digital products are delivered electronically. All sales are final once access is provided, except where required by law or if the product is defective or not as described.</p>

<h3>Digital Right of Withdrawal (Where Applicable)</h3>
<p>In some regions (e.g., EU/UK), you may have a statutory right to withdraw from a digital purchase unless you consent to immediate delivery and acknowledge that your right to withdraw is waived once access begins. Where required, we will request this consent at checkout.</p>

<h3>Free Downloads</h3>
<p>Free demos and downloads are provided as-is and do not include refunds.</p>

<h3>Physical Products (Future)</h3>
<p>If we offer physical products, return windows, eligibility, and shipping costs will be described on the product page or order confirmation.</p>

<h3>Return Windows (Where Required)</h3>
<p>Some jurisdictions provide a minimum return or withdrawal period for physical goods (often 14 or 30 days). We honor applicable local law.</p>

<h3>Statutory Rights</h3>
<p>Nothing in this policy limits your statutory rights. If your local law provides additional rights, those rights apply.</p>

<h3>How to Request a Refund</h3>
<p>Contact us at {CONTACT_EMAIL} with your order number and details.</p>
HTML;

$previousRefundContent = <<<'HTML'
<h2>Refund and Return Policy</h2>
<p>Last Updated: February 5, 2026</p>
<p>This policy applies to purchases made through {SITE_NAME}.</p>

<h3>Digital Products</h3>
<p>Digital products are delivered electronically. All sales are final once access is provided, except where required by law or if the product is defective.</p>

<h3>Physical Products (Future)</h3>
<p>If we offer physical products, return windows, eligibility, and shipping costs will be described on the product page or order confirmation.</p>

<h3>How to Request a Refund</h3>
<p>Contact us with your order number and details.</p>
<ul>
    <li>Name: {CONTACT_NAME}</li>
    <li>Email: {CONTACT_EMAIL}</li>
    <li>Phone: {CONTACT_PHONE}</li>
    <li>Address: {CONTACT_ADDRESS}</li>
</ul>

<h3>Chargebacks</h3>
<p>Initiating a chargeback without contacting support may result in account restrictions. Please contact us first so we can help resolve the issue.</p>
HTML;

$previousRefundContentV2 = <<<'HTML'
<h2>Refund and Return Policy</h2>
<p>Last Updated: February 18, 2026</p>
<p>This policy applies to purchases made through {SITE_NAME}.</p>

<h3>Digital Products</h3>
<p>For paid digital products, refunds are generally not available after delivery/access unless required by law, the product is defective, or it materially differs from its description.</p>

<h3>Free Digital Downloads</h3>
<p>Free downloads are provided as-is without warranties or refund obligations.</p>

<h3>External-Link Products</h3>
<p>For products fulfilled by a third-party external platform/store, refund and cancellation terms are governed by that third party unless mandatory law states otherwise.</p>

<h3>Physical Products</h3>
<p>Where physical goods are offered, return windows, conditions, and costs are shown at checkout or in your order confirmation.</p>

<h3>Statutory Withdrawal / Consumer Rights</h3>
<p>If your local law grants withdrawal or return rights (for example for certain consumer purchases), those rights apply and are not limited by this policy.</p>

<h3>How to Request a Refund or Return</h3>
<p>Contact us with your order number, purchase email, and reason for the request.</p>
<ul>
    <li>Name: {CONTACT_NAME}</li>
    <li>Email: {CONTACT_EMAIL}</li>
    <li>Phone: {CONTACT_PHONE}</li>
    <li>Address: {CONTACT_ADDRESS}</li>
</ul>

<h3>Chargebacks</h3>
<p>Please contact support before initiating a chargeback. Unresolved chargebacks may lead to account or purchase restrictions where legally permitted.</p>
HTML;

$defaultRefundContent = <<<'HTML'
<h2>Refund and Return Policy</h2>
<p>Last Updated: February 18, 2026</p>
<p>This policy applies to purchases made through {SITE_NAME}.</p>

<h3>Digital Products</h3>
<p>For paid digital products, refunds are generally not available after delivery/access unless required by law, the product is defective, or it materially differs from its description.</p>

<h3>Free Digital Downloads</h3>
<p>Free downloads are provided as-is without warranties or refund obligations.</p>

<h3>External-Link Products</h3>
<p>For products fulfilled by a third-party external platform/store, refund and cancellation terms are governed by that third party unless mandatory law states otherwise.</p>

<h3>Physical Products</h3>
<p>Where physical goods are offered, our standard voluntary return window is <strong>30 days from delivery</strong>, unless a longer period is required by your local law.</p>

<h3>Physical Return Eligibility</h3>
<ul>
    <li>Item must be returned in original condition (unused, clean, and complete).</li>
    <li>Proof of purchase (order number / receipt email) is required.</li>
    <li>Original packaging is recommended and may be required where legally permitted.</li>
</ul>

<h3>Non-Returnable or Restricted Items</h3>
<ul>
    <li>Personalized or custom-made items (unless defective or required by law).</li>
    <li>Sealed hygiene/health items after opening, where local law permits exclusion.</li>
    <li>Digital goods already delivered/accessed, except where mandatory law provides otherwise.</li>
</ul>

<h3>Refund Method and Timing</h3>
<p>Approved refunds are issued to the original payment method. Processing time depends on payment providers/banks and may vary by region.</p>

<h3>Return Shipping Costs</h3>
<p>Unless local law requires otherwise, return shipping costs are the buyer's responsibility unless the item is defective, damaged, or incorrect.</p>

<h3>Statutory Withdrawal / Consumer Rights</h3>
<p>If your local law grants withdrawal or return rights (for example for certain consumer purchases), those rights apply and are not limited by this policy.</p>

<h3>How to Request a Refund or Return</h3>
<p>Contact us with your order number, purchase email, and reason for the request.</p>
<ul>
    <li>Name: {CONTACT_NAME}</li>
    <li>Email: {CONTACT_EMAIL}</li>
    <li>Phone: {CONTACT_PHONE}</li>
    <li>Address: {CONTACT_ADDRESS}</li>
</ul>

<h3>Chargebacks</h3>
<p>Please contact support before initiating a chargeback. Unresolved chargebacks may lead to account or purchase restrictions where legally permitted.</p>
HTML;

// Snapshot set: legacy + previous + previous V2 + current default
$legacyShippingContent = <<<'HTML'
<h2>Shipping Policy</h2>
<p>Last Updated: February 5, 2026</p>
<p>Digital products are available immediately after purchase.</p>
<p>If physical products are offered, shipping options, costs, and estimated delivery times will be shown at checkout.</p>
<p>Questions about shipping can be sent to {CONTACT_EMAIL}.</p>
HTML;

$previousShippingContent = <<<'HTML'
<h2>Shipping Policy</h2>
<p>Last Updated: February 5, 2026</p>
<p>Digital products are available immediately after purchase.</p>
<p>If physical products are offered, shipping options, costs, and estimated delivery times will be shown at checkout. Delivery times vary by destination and carrier.</p>
<p>Questions about shipping can be sent to {CONTACT_EMAIL}.</p>
<ul>
    <li>Name: {CONTACT_NAME}</li>
    <li>Email: {CONTACT_EMAIL}</li>
    <li>Phone: {CONTACT_PHONE}</li>
    <li>Address: {CONTACT_ADDRESS}</li>
</ul>

<h3>Order Processing</h3>
<p>If physical products are offered, orders are typically processed within 1 to 2 business days unless otherwise stated on the product page.</p>

<h3>International Shipping</h3>
<p>International availability, customs duties, and import taxes (if any) will be shown at checkout or in the order confirmation. Customs fees are the responsibility of the recipient unless otherwise stated.</p>

<h3>Address Accuracy</h3>
<p>Please ensure your shipping details are correct. We are not responsible for delays or losses caused by incorrect addresses.</p>

<h3>Shipping Issues</h3>
<p>If you experience a delivery issue, contact us with your order number and details.</p>

<h3>Local Consumer Rights</h3>
<p>If local law provides additional rights relating to delivery or cancellation, those rights apply.</p>
HTML;

$previousShippingContentV2 = <<<'HTML'
<h2>Shipping Policy</h2>
<p>Last Updated: February 18, 2026</p>

<h3>Scope</h3>
<p>This Shipping Policy applies only to physical goods sold through {SITE_NAME}. Digital downloads are delivered electronically, and external-link products are fulfilled by third parties.</p>

<h3>Processing Times</h3>
<p>Physical orders are generally processed within 1 to 2 business days unless a different timeframe is shown at checkout.</p>

<h3>Delivery Times and Carriers</h3>
<p>Estimated delivery times depend on destination, customs, and carrier performance. Estimates are not guaranteed unless local law requires otherwise.</p>

<h3>Shipping Fees, Customs, and Import Taxes</h3>
<p>Shipping fees are shown at checkout. International customs duties and import taxes are the recipient’s responsibility unless expressly stated otherwise.</p>

<h3>Address Accuracy</h3>
<p>You are responsible for providing accurate shipping information. We are not responsible for delays or failed delivery caused by incorrect addresses provided at checkout.</p>

<h3>Delivery Issues</h3>
<p>If a shipment is delayed, lost, or damaged, contact us with your order number so we can investigate.</p>

<h3>Contact</h3>
<ul>
    <li>Name: {CONTACT_NAME}</li>
    <li>Email: {CONTACT_EMAIL}</li>
    <li>Phone: {CONTACT_PHONE}</li>
    <li>Address: {CONTACT_ADDRESS}</li>
</ul>

<h3>Local Consumer Rights</h3>
<p>Mandatory consumer delivery and cancellation rights under your local law remain unaffected.</p>
HTML;

$defaultShippingContent = <<<'HTML'
<h2>Shipping Policy</h2>
<p>Last Updated: February 18, 2026</p>

<h3>Scope</h3>
<p>This Shipping Policy applies only to physical goods sold through {SITE_NAME}. Digital downloads are delivered electronically, and external-link products are fulfilled by third parties.</p>

<h3>Processing Times</h3>
<p>Physical orders are generally processed within 1 to 2 business days unless a different timeframe is explicitly stated in product information or order confirmation.</p>

<h3>Delivery Times and Carriers</h3>
<p>Estimated delivery times depend on destination, customs, and carrier performance. Estimates are not guaranteed unless local law requires otherwise.</p>

<h3>Shipping Fees, Customs, and Import Taxes</h3>
<p>International customs duties and import taxes are the recipient’s responsibility unless expressly stated otherwise. Where fees are shown during order flow, those values apply to that order.</p>

<h3>Address Accuracy</h3>
<p>You are responsible for providing accurate shipping information. We are not responsible for delays or failed delivery caused by incorrect addresses provided at checkout.</p>

<h3>Delivery Issues</h3>
<p>If a shipment is delayed, lost, or damaged, contact us with your order number so we can investigate.</p>

<h3>Contact</h3>
<ul>
    <li>Name: {CONTACT_NAME}</li>
    <li>Email: {CONTACT_EMAIL}</li>
    <li>Phone: {CONTACT_PHONE}</li>
    <li>Address: {CONTACT_ADDRESS}</li>
</ul>

<h3>Local Consumer Rights</h3>
<p>Mandatory consumer delivery and cancellation rights under your local law remain unaffected.</p>
HTML;

// Snapshot set: legacy + previous + current default
$legacyLegalNoticeContent = <<<'HTML'
<h2>Legal Notice</h2>
<p>Last Updated: February 5, 2026</p>
<p>{SITE_NAME} operates {SITE_URL}.</p>
<p>For legal inquiries, contact {CONTACT_EMAIL}.</p>
HTML;

$previousLegalNoticeContent = <<<'HTML'
<h2>Legal Notice</h2>
<p>Last Updated: February 5, 2026</p>
<p>{SITE_NAME} operates {SITE_URL}.</p>
<h3>Operator</h3>
<ul>
    <li>Name: {CONTACT_NAME}</li>
    <li>Email: {CONTACT_EMAIL}</li>
    <li>Phone: {CONTACT_PHONE}</li>
    <li>Address: {CONTACT_ADDRESS}</li>
</ul>
HTML;

$defaultLegalNoticeContent = <<<'HTML'
<h2>Legal Notice</h2>
<p>Last Updated: February 5, 2026</p>
<p>{SITE_NAME} operates {SITE_URL}.</p>

<h3>Provider Information</h3>
<ul>
    <li>Legal Entity: {LEGAL_ENTITY_NAME}</li>
    <li>Legal Form: {LEGAL_LEGAL_FORM}</li>
    <li>Authorized Representative: {LEGAL_REPRESENTATIVE}</li>
    <li>Address: {LEGAL_FULL_ADDRESS}</li>
    <li>Email: {CONTACT_EMAIL}</li>
    <li>Phone: {CONTACT_PHONE}</li>
</ul>

<h3>Register Entry</h3>
<ul>
    <li>Register Court/Authority: {LEGAL_REGISTER_COURT}</li>
    <li>Register Number: {LEGAL_REGISTER_NUMBER}</li>
    <li>VAT ID: {LEGAL_VAT_ID}</li>
    <li>Business ID: {LEGAL_BUSINESS_ID}</li>
</ul>

<h3>Editorial Responsibility (§18 MStV)</h3>
<ul>
    <li>Responsible for content: {LEGAL_EDITOR_NAME}</li>
    <li>Address: {LEGAL_EDITOR_ADDRESS}</li>
</ul>

<h3>Regulated Profession (if applicable)</h3>
<ul>
    <li>Profession: {LEGAL_PROFESSION_NAME}</li>
    <li>Professional Title: {LEGAL_PROFESSIONAL_TITLE}</li>
    <li>Title awarded in: {LEGAL_PROFESSIONAL_TITLE_COUNTRY}</li>
    <li>Chamber / Professional body: {LEGAL_CHAMBER}</li>
    <li>Professional rules: {LEGAL_PROFESSIONAL_RULES}</li>
    <li>Rules URL: {LEGAL_PROFESSIONAL_RULES_LINK}</li>
</ul>

<h3>Supervisory Authority</h3>
<p>{LEGAL_SUPERVISORY_AUTHORITY}</p>

<h3>Online Dispute Resolution</h3>
<p>EU ODR platform: {LEGAL_ODR_LINK}</p>
<p>{LEGAL_DISPUTE_PARTICIPATION}</p>

<h3>Hosting Provider</h3>
<ul>
    <li>Name: {LEGAL_HOSTING_PROVIDER_NAME}</li>
    <li>Address: {LEGAL_HOSTING_PROVIDER_ADDRESS}</li>
</ul>
HTML;

$defaultDmcaContent = <<<'HTML'
<h2>DMCA Takedown Policy</h2>
<p>This page explains how to submit a DMCA takedown notice or counter-notice.</p>
<h3>How to Submit a Takedown Notice</h3>
<p>Please provide the following:</p>
<ul>
    <li>Your full legal name, address, phone number, and email address.</li>
    <li>Identification of the copyrighted work you claim has been infringed.</li>
    <li>Exact URL(s) or location(s) of the allegedly infringing content.</li>
    <li>A statement that you have a good-faith belief the use is not authorized.</li>
    <li>A statement made under penalty of perjury that your notice is accurate and you are the rights holder or authorized to act on their behalf.</li>
    <li>Your physical or electronic signature.</li>
</ul>
<h3>Where to Send Notices</h3>
<p>Email: {CONTACT_EMAIL}</p>
<h3>Counter-Notice</h3>
<p>If you believe content was removed in error, you may submit a counter-notice with your contact details, the removed content location, a statement under penalty of perjury that removal was a mistake, and consent to jurisdiction.</p>
HTML;

$legalPages = [
    'privacy-policy' => [
        'title' => PAGE_TITLE_PRIVACY_POLICY,
        'content' => $defaultPrivacyContent,
        'meta_title' => PAGE_TITLE_PRIVACY_POLICY,
        'meta_description' => 'Our privacy policy explains how we handle your data',
        'is_published' => 1
    ],
    'terms-of-service' => [
        'title' => PAGE_TITLE_TERMS_OF_SERVICE,
        'content' => $defaultTermsContent,
        'meta_title' => PAGE_TITLE_TERMS_OF_SERVICE,
        'meta_description' => 'Terms and conditions for using our website',
        'is_published' => 1
    ],
    'dmca' => [
        'title' => 'DMCA',
        'content' => $defaultDmcaContent,
        'meta_title' => 'DMCA',
        'meta_description' => 'Digital Millennium Copyright Act (DMCA) policy',
        'is_published' => 1
    ],
    'refund-policy' => [
        'title' => PAGE_TITLE_REFUND_POLICY,
        'content' => $defaultRefundContent,
        'meta_title' => PAGE_TITLE_REFUND_POLICY,
        'meta_description' => 'Refunds and returns policy',
        'is_published' => 0
    ],
    'shipping-policy' => [
        'title' => PAGE_TITLE_SHIPPING_POLICY,
        'content' => $defaultShippingContent,
        'meta_title' => PAGE_TITLE_SHIPPING_POLICY,
        'meta_description' => 'Shipping and delivery information',
        'is_published' => 0
    ],
    'legal-notice' => [
        'title' => PAGE_TITLE_LEGAL_NOTICE,
        'content' => $defaultLegalNoticeContent,
        'meta_title' => PAGE_TITLE_LEGAL_NOTICE,
        'meta_description' => 'Legal notice and contact information',
        'is_published' => 0
    ]
];

foreach ($legalPages as $slug => $pageInfo) {
    $stmt = $db->prepare("SELECT id FROM pages WHERE slug = ? LIMIT 1");
    $stmt->execute([$slug]);
    if (!$stmt->fetch()) {
        $insertStmt = $db->prepare("INSERT INTO pages (title, slug, content, meta_title, meta_description, is_published) VALUES (?, ?, ?, ?, ?, ?)");
        $insertStmt->execute([
            $pageInfo['title'],
            $slug,
            $pageInfo['content'],
            $pageInfo['meta_title'],
            $pageInfo['meta_description'],
            $pageInfo['is_published']
        ]);
    }
}

$privacyCheck = $db->prepare("SELECT id, content FROM pages WHERE slug = 'privacy-policy' LIMIT 1");
$privacyCheck->execute();
$privacyRow = $privacyCheck->fetch(PDO::FETCH_ASSOC);
if ($privacyRow) {
    $privacyContent = (string)($privacyRow['content'] ?? '');
    $shouldUpdate = trim(strip_tags($privacyContent)) === ''
        || trim($privacyContent) === trim($legacyPrivacyContent)
        || trim($privacyContent) === trim($previousPrivacyContent)
        || trim($privacyContent) === trim($previousPrivacyContentV2)
        || stripos($privacyContent, 'Last Updated: January 18, 2026') !== false;
    if ($shouldUpdate) {
        $stmt = $db->prepare(SQL_UPDATE_PAGE_CONTENT_META_BY_ID);
        $stmt->execute([$defaultPrivacyContent, PAGE_TITLE_PRIVACY_POLICY, 'Our privacy policy explains how we handle your data', $privacyRow['id']]);
    }
}

$termsCheck = $db->prepare("SELECT id, content FROM pages WHERE slug = 'terms-of-service' LIMIT 1");
$termsCheck->execute();
$termsRow = $termsCheck->fetch(PDO::FETCH_ASSOC);
if ($termsRow) {
    $termsContent = (string)($termsRow['content'] ?? '');
    $shouldUpdate = trim(strip_tags($termsContent)) === ''
        || trim($termsContent) === trim($legacyTermsContent)
        || trim($termsContent) === trim($previousTermsContent)
        || stripos($termsContent, 'Please read these terms carefully before downloading') !== false
        || stripos($termsContent, 'License to Play') !== false;
    if ($shouldUpdate) {
        $stmt = $db->prepare(SQL_UPDATE_PAGE_CONTENT_META_BY_ID);
        $stmt->execute([$defaultTermsContent, PAGE_TITLE_TERMS_OF_SERVICE, 'Terms and conditions for using our website', $termsRow['id']]);
    }
}

$refundCheck = $db->prepare("SELECT id, content FROM pages WHERE slug = 'refund-policy' LIMIT 1");
$refundCheck->execute();
$refundRow = $refundCheck->fetch(PDO::FETCH_ASSOC);
if ($refundRow) {
    $refundContent = (string)($refundRow['content'] ?? '');
    $shouldUpdate = trim(strip_tags($refundContent)) === ''
        || trim($refundContent) === trim($legacyRefundContent)
        || trim($refundContent) === trim($previousRefundContent)
        || trim($refundContent) === trim($previousRefundContentV2);
    if ($shouldUpdate) {
        $stmt = $db->prepare(SQL_UPDATE_PAGE_CONTENT_META_BY_ID);
        $stmt->execute([$defaultRefundContent, PAGE_TITLE_REFUND_POLICY, 'Refunds and returns policy', $refundRow['id']]);
    }
}

$shippingCheck = $db->prepare("SELECT id, content FROM pages WHERE slug = 'shipping-policy' LIMIT 1");
$shippingCheck->execute();
$shippingRow = $shippingCheck->fetch(PDO::FETCH_ASSOC);
if ($shippingRow) {
    $shippingContent = (string)($shippingRow['content'] ?? '');
    $shouldUpdate = trim(strip_tags($shippingContent)) === ''
        || trim($shippingContent) === trim($legacyShippingContent)
        || trim($shippingContent) === trim($previousShippingContent)
        || trim($shippingContent) === trim($previousShippingContentV2);
    if ($shouldUpdate) {
        $stmt = $db->prepare(SQL_UPDATE_PAGE_CONTENT_META_BY_ID);
        $stmt->execute([$defaultShippingContent, PAGE_TITLE_SHIPPING_POLICY, 'Shipping and delivery information', $shippingRow['id']]);
    }
}

$noticeCheck = $db->prepare("SELECT id, content FROM pages WHERE slug = 'legal-notice' LIMIT 1");
$noticeCheck->execute();
$noticeRow = $noticeCheck->fetch(PDO::FETCH_ASSOC);
if ($noticeRow) {
    $noticeContent = (string)($noticeRow['content'] ?? '');
    $shouldUpdate = trim(strip_tags($noticeContent)) === ''
        || trim($noticeContent) === trim($legacyLegalNoticeContent)
        || trim($noticeContent) === trim($previousLegalNoticeContent);
    if ($shouldUpdate) {
        $stmt = $db->prepare(SQL_UPDATE_PAGE_CONTENT_META_BY_ID);
        $stmt->execute([$defaultLegalNoticeContent, PAGE_TITLE_LEGAL_NOTICE, 'Legal notice and contact information', $noticeRow['id']]);
    }
}

$slugs = array_keys($legalPages);
$placeholders = implode(',', array_fill(0, count($slugs), '?'));
$stmt = $db->prepare("SELECT * FROM pages WHERE slug IN ($placeholders)");
$stmt->execute($slugs);
$pages = $stmt->fetchAll(PDO::FETCH_ASSOC);
$pageMap = [];
foreach ($pages as $row) {
    $pageMap[$row['slug']] = $row;
}

$orderedPages = [];
foreach ($slugs as $slug) {
    if (isset($pageMap[$slug])) {
        $orderedPages[] = $pageMap[$slug];
    }
}

$previewSlug = trim((string)($_GET['preview_default'] ?? ''));
$previewPage = null;
$previewContent = '';
if ($previewSlug !== '' && isset($legalPages[$previewSlug])) {
    $previewPage = $legalPages[$previewSlug];
    $previewPage['slug'] = $previewSlug;
    $previewContent = ContentRenderer::renderPageContentPlaceholders((string)($previewPage['content'] ?? ''));
}

AdminLayout::renderHeader();
?>

<div class="admin-content">
    <div class="content-header content-header-actions">
        <div>
            <h1>Legal Pages</h1>
            <p>Manage policy and legal documents.</p>
        </div>
        <a href="/admin/pages.php" class="btn btn-secondary">All Pages</a>
    </div>

    <?php if ($message): ?>
    <div class="alert alert-success"><?php echo e($message); ?></div>
    <?php endif; ?>

    <?php if ($error): ?>
    <div class="alert alert-error"><?php echo e($error); ?></div>
    <?php endif; ?>

    <?php if ($previewPage): ?>
    <div class="card">
        <div class="card-header content-header-actions">
            <div>
                <h3>Default Preview: <?php echo e($previewPage['title'] ?? ''); ?></h3>
                <p class="text-muted">Rendered with current placeholders. This does not modify saved page content.</p>
            </div>
            <a href="/admin/legal-pages.php" class="btn btn-secondary">Close Preview</a>
        </div>
        <div class="card-body">
            <div class="text-muted mb-2"><code>/<?php echo e($previewPage['slug'] ?? ''); ?></code></div>
            <div class="legal-preview-content"><?php echo $previewContent; ?></div>
        </div>
    </div>
    <?php endif; ?>

    <div class="table-container">
        <table class="data-table">
            <thead>
                <tr>
                    <th>Title</th>
                    <th>Slug</th>
                    <th>Status</th>
                    <th>Updated</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($orderedPages)): ?>
                <tr>
                    <td colspan="5" class="text-center text-muted">No legal pages found.</td>
                </tr>
                <?php else: ?>
                <?php foreach ($orderedPages as $p): ?>
                <tr>
                    <td><?php echo e($p['title']); ?> <span class="page-system-badge">System</span></td>
                    <td><code>/<?php echo e($p['slug']); ?></code></td>
                    <td>
                        <?php if (!empty($p['is_published'])): ?>
                        <span class="status-published">Published</span>
                        <?php else: ?>
                        <span class="status-draft">Draft</span>
                        <?php endif; ?>
                    </td>
                    <td><?php echo e(date('M j, Y', strtotime($p['updated_at']))); ?></td>
                    <td class="table-actions">
                        <a href="/admin/pages.php?action=edit&id=<?php echo (int)$p['id']; ?>" class="btn btn-secondary btn-sm">Edit</a>
                        <a href="/admin/theme-editor.php?page=<?php echo (int)$p['id']; ?>" class="btn btn-secondary btn-sm">Edit Layout</a>
                        <a href="/admin/legal-pages.php?preview_default=<?php echo urlencode((string)$p['slug']); ?>" class="btn btn-secondary btn-sm">Preview Default</a>
                        <a href="/<?php echo e($p['slug']); ?>" target="_blank" class="btn btn-secondary btn-sm">View</a>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div class="text-muted mt-16">
        Placeholders you can use in legal pages: {SITE_NAME}, {SITE_URL}, {CONTACT_EMAIL}, {CONTACT_NAME}, {CONTACT_PHONE}, {CONTACT_ADDRESS}, {LEGAL_ENTITY_NAME}, {LEGAL_LEGAL_FORM}, {LEGAL_REPRESENTATIVE}, {LEGAL_FULL_ADDRESS}, {LEGAL_REGISTER_COURT}, {LEGAL_REGISTER_NUMBER}, {LEGAL_VAT_ID}, {LEGAL_BUSINESS_ID}, {LEGAL_EDITOR_NAME}, {LEGAL_EDITOR_ADDRESS}, {LEGAL_PROFESSION_NAME}, {LEGAL_PROFESSIONAL_TITLE}, {LEGAL_PROFESSIONAL_TITLE_COUNTRY}, {LEGAL_CHAMBER}, {LEGAL_PROFESSIONAL_RULES}, {LEGAL_PROFESSIONAL_RULES_LINK}, {LEGAL_SUPERVISORY_AUTHORITY}, {LEGAL_ODR_LINK}, {LEGAL_DISPUTE_PARTICIPATION}, {LEGAL_HOSTING_PROVIDER_NAME}, {LEGAL_HOSTING_PROVIDER_ADDRESS}
    </div>
</div>

<?php AdminLayout::renderFooter(); ?>
