<?php
/**
 * Admin Panel - Email Templates
 */

if (!defined('ROOT_PATH')) {
    http_response_code(403);
    exit;
}

use NewSite\Auth\AdminAuth;
use NewSite\Settings\SettingsService;
use NewSite\Admin\AdminLayout;

AdminAuth::requireLogin();

$message = $_GET['message'] ?? '';
$error = $_GET['error'] ?? '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    verifyCSRF();

    SettingsService::set('purchase_email_subject', trim($_POST['purchase_email_subject'] ?? ''));
    SettingsService::set('purchase_email_body', trim($_POST['purchase_email_body'] ?? ''));
    SettingsService::set('product_update_email_subject', trim($_POST['product_update_email_subject'] ?? ''));
    SettingsService::set('product_update_email_body', trim($_POST['product_update_email_body'] ?? ''));
    SettingsService::set('login_email_subject', trim($_POST['login_email_subject'] ?? ''));
    SettingsService::set('login_email_body', trim($_POST['login_email_body'] ?? ''));

    SettingsService::set('dmca_request_subject', trim($_POST['dmca_request_subject'] ?? ''));
    SettingsService::set('dmca_request_body', trim($_POST['dmca_request_body'] ?? ''));
    SettingsService::set('dmca_verified_subject', trim($_POST['dmca_verified_subject'] ?? ''));
    SettingsService::set('dmca_verified_body', trim($_POST['dmca_verified_body'] ?? ''));

    SettingsService::set('dmca_status_in_review_subject', trim($_POST['dmca_status_in_review_subject'] ?? ''));
    SettingsService::set('dmca_status_in_review_body', trim($_POST['dmca_status_in_review_body'] ?? ''));
    SettingsService::set('dmca_status_rejected_subject', trim($_POST['dmca_status_rejected_subject'] ?? ''));
    SettingsService::set('dmca_status_rejected_body', trim($_POST['dmca_status_rejected_body'] ?? ''));
    SettingsService::set('dmca_status_actioned_subject', trim($_POST['dmca_status_actioned_subject'] ?? ''));
    SettingsService::set('dmca_status_actioned_body', trim($_POST['dmca_status_actioned_body'] ?? ''));
    SettingsService::set('dmca_status_closed_subject', trim($_POST['dmca_status_closed_subject'] ?? ''));
    SettingsService::set('dmca_status_closed_body', trim($_POST['dmca_status_closed_body'] ?? ''));

    header('Location: /admin/email-templates.php?message=' . urlencode('Email templates updated.'));
    exit;
}

$purchaseEmailSubject = SettingsService::get('purchase_email_subject', 'Thanks for your purchase');
$purchaseEmailBody = SettingsService::get('purchase_email_body', "Hi {name},\n\nThanks for your purchase!\nYou can view your purchase anytime by logging into your account: {account_url}\n\nOrder: {order_number}\nTotal: {total}\n\nThank you!\n");
$productUpdateEmailSubject = SettingsService::get('product_update_email_subject', 'New update available: {product_name}');
$productUpdateEmailBody = SettingsService::get('product_update_email_body', "Hi {name},\n\nGreat news! A new update is available for {product_name}.\n\nVersion: {version}\n\n{changelog}\n\nLog in to your account to download the latest version:\n{account_url}\n\nThank you!");
$loginEmailSubject = SettingsService::get('login_email_subject', 'Your login link');
$loginEmailBody = SettingsService::get('login_email_body', "Hello,\n\nUse the link below to log in:\n{login_url}\n\nIf you did not request this, you can ignore this email.\n\nThank you,\n{site_name}");

$dmcaRequestSubject = SettingsService::get('dmca_request_subject', 'Verify your DMCA request');
$dmcaRequestBody = SettingsService::get('dmca_request_body', "Hello {name},\n\nPlease verify your DMCA request by clicking the link below:\n{verify_url}\n\nIf you did not submit this request, you can ignore this email.\n\nThank you,\n{site_name}");
$dmcaVerifiedSubject = SettingsService::get('dmca_verified_subject', 'Your DMCA request is verified');
$dmcaVerifiedBody = SettingsService::get('dmca_verified_body', "Hello {name},\n\nYour DMCA request (ID {request_id}) is verified. Our team will review it and contact you if more information is needed.\n\nIf you have questions, contact {contact_email}.\n\nThank you,\n{site_name}");

$dmcaStatusInReviewSubject = SettingsService::get('dmca_status_in_review_subject', 'DMCA request in review');
$dmcaStatusInReviewBody = SettingsService::get('dmca_status_in_review_body', "Hello {name},\n\nYour DMCA request (ID {request_id}) is now in review.\n\nWe will contact you if we need more information.\n\nThank you,\n{site_name}");
$dmcaStatusRejectedSubject = SettingsService::get('dmca_status_rejected_subject', 'DMCA request rejected');
$dmcaStatusRejectedBody = SettingsService::get('dmca_status_rejected_body', "Hello {name},\n\nYour DMCA request (ID {request_id}) has been rejected.\n\nIf you believe this is a mistake, contact {contact_email}.\n\nThank you,\n{site_name}");
$dmcaStatusActionedSubject = SettingsService::get('dmca_status_actioned_subject', 'DMCA request actioned');
$dmcaStatusActionedBody = SettingsService::get('dmca_status_actioned_body', "Hello {name},\n\nYour DMCA request (ID {request_id}) has been actioned.\n\nThank you,\n{site_name}");
$dmcaStatusClosedSubject = SettingsService::get('dmca_status_closed_subject', 'DMCA request closed');
$dmcaStatusClosedBody = SettingsService::get('dmca_status_closed_body', "Hello {name},\n\nYour DMCA request (ID {request_id}) has been closed.\n\nThank you,\n{site_name}");

AdminLayout::renderHeader();
?>

<div class="admin-content">
    <div class="content-header content-header-actions">
        <div>
            <h1>Email Templates</h1>
            <p>Manage email subjects and message bodies sent by the site.</p>
        </div>
        <button type="submit" form="email-templates-form" class="btn btn-primary">Save Templates</button>
    </div>

    <?php if ($message): ?>
    <div class="alert alert-success"><?php echo e($message); ?></div>
    <?php endif; ?>

    <?php if ($error): ?>
    <div class="alert alert-error"><?php echo e($error); ?></div>
    <?php endif; ?>

    <form id="email-templates-form" method="POST" action="/admin/email-templates.php">
        <input type="hidden" name="csrf_token" value="<?php echo e(getCsrfToken()); ?>">

        <div class="card">
            <div class="card-header">
                <h3>Purchase Email</h3>
            </div>
            <div class="card-body">
                <div class="form-group">
                    <label for="purchase_email_subject">Email Subject</label>
                    <input type="text" id="purchase_email_subject" name="purchase_email_subject" class="form-control" value="<?php echo e($purchaseEmailSubject); ?>">
                </div>
                <div class="form-group">
                    <label for="purchase_email_body">Email Message</label>
                    <textarea id="purchase_email_body" name="purchase_email_body" class="form-control" rows="7"><?php echo e($purchaseEmailBody); ?></textarea>
                    <small class="text-muted">Variables: {name}, {order_number}, {total}, {currency}, {account_url}</small>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h3>Product Update Email</h3>
            </div>
            <div class="card-body">
                <div class="form-group">
                    <label for="product_update_email_subject">Email Subject</label>
                    <input type="text" id="product_update_email_subject" name="product_update_email_subject" class="form-control" value="<?php echo e($productUpdateEmailSubject); ?>">
                </div>
                <div class="form-group">
                    <label for="product_update_email_body">Email Message</label>
                    <textarea id="product_update_email_body" name="product_update_email_body" class="form-control" rows="7"><?php echo e($productUpdateEmailBody); ?></textarea>
                    <small class="text-muted">Variables: {name}, {product_name}, {version}, {changelog}, {account_url}</small>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h3>Login Email</h3>
            </div>
            <div class="card-body">
                <div class="form-group">
                    <label for="login_email_subject">Email Subject</label>
                    <input type="text" id="login_email_subject" name="login_email_subject" class="form-control" value="<?php echo e($loginEmailSubject); ?>">
                </div>
                <div class="form-group">
                    <label for="login_email_body">Email Message</label>
                    <textarea id="login_email_body" name="login_email_body" class="form-control" rows="7"><?php echo e($loginEmailBody); ?></textarea>
                    <small class="text-muted">Variables: {login_url}, {email}, {site_name}</small>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h3>DMCA Verification Email</h3>
            </div>
            <div class="card-body">
                <div class="form-group">
                    <label for="dmca_request_subject">Email Subject</label>
                    <input type="text" id="dmca_request_subject" name="dmca_request_subject" class="form-control" value="<?php echo e($dmcaRequestSubject); ?>">
                </div>
                <div class="form-group">
                    <label for="dmca_request_body">Email Message</label>
                    <textarea id="dmca_request_body" name="dmca_request_body" class="form-control" rows="7"><?php echo e($dmcaRequestBody); ?></textarea>
                    <small class="text-muted">Variables: {name}, {verify_url}, {request_id}, {contact_email}, {site_name}</small>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h3>DMCA Verified Email</h3>
            </div>
            <div class="card-body">
                <div class="form-group">
                    <label for="dmca_verified_subject">Email Subject</label>
                    <input type="text" id="dmca_verified_subject" name="dmca_verified_subject" class="form-control" value="<?php echo e($dmcaVerifiedSubject); ?>">
                </div>
                <div class="form-group">
                    <label for="dmca_verified_body">Email Message</label>
                    <textarea id="dmca_verified_body" name="dmca_verified_body" class="form-control" rows="7"><?php echo e($dmcaVerifiedBody); ?></textarea>
                    <small class="text-muted">Variables: {name}, {request_id}, {contact_email}, {site_name}</small>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h3>DMCA Status - In Review</h3>
            </div>
            <div class="card-body">
                <div class="form-group">
                    <label for="dmca_status_in_review_subject">Email Subject</label>
                    <input type="text" id="dmca_status_in_review_subject" name="dmca_status_in_review_subject" class="form-control" value="<?php echo e($dmcaStatusInReviewSubject); ?>">
                </div>
                <div class="form-group">
                    <label for="dmca_status_in_review_body">Email Message</label>
                    <textarea id="dmca_status_in_review_body" name="dmca_status_in_review_body" class="form-control" rows="7"><?php echo e($dmcaStatusInReviewBody); ?></textarea>
                    <small class="text-muted">Variables: {name}, {request_id}, {status}, {status_label}, {contact_email}, {site_name}</small>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h3>DMCA Status - Rejected</h3>
            </div>
            <div class="card-body">
                <div class="form-group">
                    <label for="dmca_status_rejected_subject">Email Subject</label>
                    <input type="text" id="dmca_status_rejected_subject" name="dmca_status_rejected_subject" class="form-control" value="<?php echo e($dmcaStatusRejectedSubject); ?>">
                </div>
                <div class="form-group">
                    <label for="dmca_status_rejected_body">Email Message</label>
                    <textarea id="dmca_status_rejected_body" name="dmca_status_rejected_body" class="form-control" rows="7"><?php echo e($dmcaStatusRejectedBody); ?></textarea>
                    <small class="text-muted">Variables: {name}, {request_id}, {status}, {status_label}, {contact_email}, {site_name}</small>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h3>DMCA Status - Actioned</h3>
            </div>
            <div class="card-body">
                <div class="form-group">
                    <label for="dmca_status_actioned_subject">Email Subject</label>
                    <input type="text" id="dmca_status_actioned_subject" name="dmca_status_actioned_subject" class="form-control" value="<?php echo e($dmcaStatusActionedSubject); ?>">
                </div>
                <div class="form-group">
                    <label for="dmca_status_actioned_body">Email Message</label>
                    <textarea id="dmca_status_actioned_body" name="dmca_status_actioned_body" class="form-control" rows="7"><?php echo e($dmcaStatusActionedBody); ?></textarea>
                    <small class="text-muted">Variables: {name}, {request_id}, {status}, {status_label}, {contact_email}, {site_name}</small>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h3>DMCA Status - Closed</h3>
            </div>
            <div class="card-body">
                <div class="form-group">
                    <label for="dmca_status_closed_subject">Email Subject</label>
                    <input type="text" id="dmca_status_closed_subject" name="dmca_status_closed_subject" class="form-control" value="<?php echo e($dmcaStatusClosedSubject); ?>">
                </div>
                <div class="form-group">
                    <label for="dmca_status_closed_body">Email Message</label>
                    <textarea id="dmca_status_closed_body" name="dmca_status_closed_body" class="form-control" rows="7"><?php echo e($dmcaStatusClosedBody); ?></textarea>
                    <small class="text-muted">Variables: {name}, {request_id}, {status}, {status_label}, {contact_email}, {site_name}</small>
                </div>
            </div>
        </div>

        <div class="form-group">
            <button type="submit" class="btn btn-primary">Save Templates</button>
        </div>
    </form>
</div>

<?php AdminLayout::renderFooter(); ?>
