$ErrorActionPreference = "Stop"

$scriptDir = Split-Path -Parent $MyInvocation.MyCommand.Path
$appRoot = Resolve-Path (Join-Path $scriptDir "..")
$certDir = Join-Path $appRoot "cert"
if (-not (Test-Path $certDir)) { New-Item -ItemType Directory -Path $certDir | Out-Null }

$certPem = Join-Path $certDir "cert.pem"
$keyPem = Join-Path $certDir "key.pem"
$opensslCnf = Join-Path $scriptDir "openssl.cnf"

if ((Test-Path $certPem) -and (Test-Path $keyPem)) {
    Write-Host "Cert already exists." -ForegroundColor Yellow
} else {
    Write-Host "Generating self-signed cert for localhost..." -ForegroundColor Cyan
    $env:OPENSSL_CONF = $opensslCnf
    openssl req -x509 -newkey rsa:2048 -keyout $keyPem -out $certPem -days 365 -nodes -config $opensslCnf
}

Write-Host "Trusting cert in CurrentUser Root store..." -ForegroundColor Cyan
certutil -user -addstore -f "Root" $certPem | Out-Null
Write-Host "Cert installed." -ForegroundColor Green
