// Copyright (c) 2026 CelestiaDominance. All Rights Reserved.

#pragma once

#include "CoreMinimal.h"
#include "Modules/ModuleManager.h"

class FActionRegistry;
class FConversationManager;
class IAIProvider;

class FBlueprintAIAssistantModule : public IModuleInterface
{
public:
	virtual void StartupModule() override;
	virtual void ShutdownModule() override;

	static FBlueprintAIAssistantModule& Get();

	TSharedPtr<FActionRegistry> GetActionRegistry() const { return ActionRegistry; }
	TSharedPtr<FConversationManager> GetConversationManager() const { return ConversationManager; }

	/** Recreate the AI provider based on current settings */
	void RefreshAIProvider();

	TSharedPtr<IAIProvider> GetCurrentProvider() const { return CurrentProvider; }

private:
	void RegisterTab();
	void UnregisterTab();
	void RegisterMenus();

	TSharedRef<class SDockTab> SpawnTab(const class FSpawnTabArgs& Args);

	TSharedPtr<FActionRegistry> ActionRegistry;
	TSharedPtr<FConversationManager> ConversationManager;
	TSharedPtr<IAIProvider> CurrentProvider;

	static const FName AIAssistantTabId;
};
