// Copyright (c) 2026 CelestiaDominance. All Rights Reserved.

#pragma once

#include "Actions/IBlueprintAction.h"

/**
 * Action: set_variable_defaults
 * Sets the default value, replication, and expose-on-spawn flags for a Blueprint variable.
 */
class FSetVariableDefaultsAction : public IBlueprintAction
{
public:
	virtual FString GetName() const override { return TEXT("set_variable_defaults"); }

	virtual FString GetDescription() const override
	{
		return TEXT("Sets the default value and property flags for a Blueprint variable. "
			"Can set the default value, make it replicated, expose on spawn, or set as read-only.");
	}

	virtual TSharedPtr<FJsonObject> GetParameterSchema() const override;
	virtual FBlueprintActionResult Execute(const TSharedPtr<FJsonObject>& Params) override;
};
