// Copyright (c) 2026 CelestiaDominance. All Rights Reserved.

#pragma once

#include "Actions/IBlueprintAction.h"

class FActionRegistry;

/**
 * Action: set_pin_value
 * Sets the default value on a node's pin.
 */
class FSetPinValueAction : public IBlueprintAction
{
public:
	FSetPinValueAction(FActionRegistry* InRegistry) : Registry(InRegistry) {}

	virtual FString GetName() const override { return TEXT("set_pin_value"); }

	virtual FString GetDescription() const override
	{
		return TEXT("Sets the default value of a pin on a tracked node. "
			"Use this to set literal values on pins that are not connected to other nodes. "
			"For example, setting a float literal, a string value, or a boolean default.");
	}

	virtual TSharedPtr<FJsonObject> GetParameterSchema() const override;
	virtual FBlueprintActionResult Execute(const TSharedPtr<FJsonObject>& Params) override;

private:
	FActionRegistry* Registry = nullptr;
};
