// Copyright (c) 2026 CelestiaDominance. All Rights Reserved.

#pragma once

#include "Actions/IBlueprintAction.h"

class FActionRegistry;

/**
 * Action: set_node_comment
 * Sets or clears the comment text on a tracked node.
 * The comment appears as a tooltip/bubble on the node in the graph editor.
 */
class FSetNodeCommentAction : public IBlueprintAction
{
public:
	FSetNodeCommentAction(FActionRegistry* InRegistry) : Registry(InRegistry) {}

	virtual FString GetName() const override { return TEXT("set_node_comment"); }

	virtual FString GetDescription() const override
	{
		return TEXT("Sets a comment on a tracked node. The comment appears as text on the node in the Blueprint graph. "
			"Use this to annotate nodes with descriptions for the user. "
			"Pass an empty comment to clear it.");
	}

	virtual TSharedPtr<FJsonObject> GetParameterSchema() const override;
	virtual FBlueprintActionResult Execute(const TSharedPtr<FJsonObject>& Params) override;

private:
	FActionRegistry* Registry = nullptr;
};
