// Copyright (c) 2026 CelestiaDominance. All Rights Reserved.

#pragma once

#include "Actions/IBlueprintAction.h"

/**
 * Action: set_component_property
 * Sets a property value on a component in a Blueprint's component hierarchy.
 */
class FSetComponentPropertyAction : public IBlueprintAction
{
public:
	virtual FString GetName() const override { return TEXT("set_component_property"); }

	virtual FString GetDescription() const override
	{
		return TEXT("Sets a property on a Blueprint component (added via add_component). "
			"Use the component_name returned by add_component. "
			"Common properties: StaticMeshComponent→'StaticMesh' (asset path e.g. '/Engine/BasicShapes/Sphere.Sphere'), "
			"'RelativeLocation' ('X=0,Y=0,Z=0'), 'RelativeScale3D', 'RelativeRotation', "
			"'Mobility' ('Static'/'Stationary'/'Movable'), 'CastShadow' (true/false), 'bHiddenInGame', "
			"'InitialSpeed', 'MaxSpeed', 'bShouldBounce'. "
			"Collision properties (PrimitiveComponent): "
			"'CollisionProfileName' ('NoCollision', 'OverlapAll', 'BlockAll', 'Projectile', 'OverlapAllDynamic', etc.), "
			"'CollisionEnabled' ('NoCollision', 'QueryOnly', 'PhysicsOnly', 'QueryAndPhysics'), "
			"'bSimulatePhysics' (true/false), 'bGenerateOverlapEvents' (true/false), "
			"'CollisionResponseToAllChannels' ('Block', 'Overlap', 'Ignore'), "
			"'bNotifyRigidBodyCollision' (true/false). "
			"For object properties (meshes, materials), use the full content path.");
	}

	virtual TSharedPtr<FJsonObject> GetParameterSchema() const override;
	virtual FBlueprintActionResult Execute(const TSharedPtr<FJsonObject>& Params) override;
};
