// Copyright (c) 2026 CelestiaDominance. All Rights Reserved.

#pragma once

#include "Actions/IBlueprintAction.h"

class FActionRegistry;

/**
 * Action: search_blueprint_nodes
 * Targeted search: returns only nodes matching a keyword filter.
 * Much lighter than get_blueprint_info with include_nodes=true.
 * Searches node titles, class names, and pin names.
 */
class FSearchBlueprintNodesAction : public IBlueprintAction
{
public:
	FSearchBlueprintNodesAction(FActionRegistry* InRegistry) : Registry(InRegistry) {}

	virtual FString GetName() const override { return TEXT("search_blueprint_nodes"); }

	virtual FString GetDescription() const override
	{
		return TEXT("Search for specific nodes in a Blueprint by keyword. Returns only matching nodes with their pins and connections. "
			"Much more efficient than get_blueprint_info with include_nodes=true when you only need to find specific nodes. "
			"Searches node titles, class names, and pin names. Example: search for 'Jump' to find jump-related nodes, "
			"or 'BeginPlay' to find the BeginPlay event.");
	}

	virtual TSharedPtr<FJsonObject> GetParameterSchema() const override;
	virtual FBlueprintActionResult Execute(const TSharedPtr<FJsonObject>& Params) override;

private:
	FActionRegistry* Registry;
};
