// Copyright (c) 2026 CelestiaDominance. All Rights Reserved.

#pragma once

#include "Actions/IBlueprintAction.h"

/**
 * Action: save_memory
 * Saves a persistent memory/fact that will be recalled in all future conversations.
 */
class FSaveMemoryAction : public IBlueprintAction
{
public:
	virtual FString GetName() const override { return TEXT("save_memory"); }

	virtual FString GetDescription() const override
	{
		return TEXT("Save a persistent memory/fact that will be recalled in all future conversations. "
			"Use this to remember user preferences, project conventions, or important learnings.");
	}

	virtual TSharedPtr<FJsonObject> GetParameterSchema() const override;
	virtual FBlueprintActionResult Execute(const TSharedPtr<FJsonObject>& Params) override;
};
