// Copyright (c) 2026 CelestiaDominance. All Rights Reserved.

#pragma once

#include "Actions/IBlueprintAction.h"

/**
 * Action: rename_variable
 * Renames a variable in a Blueprint. Updates all references.
 */
class FRenameVariableAction : public IBlueprintAction
{
public:
	virtual FString GetName() const override { return TEXT("rename_variable"); }

	virtual FString GetDescription() const override
	{
		return TEXT("Renames a variable in a Blueprint. All references to the variable in nodes are automatically updated.");
	}

	virtual TSharedPtr<FJsonObject> GetParameterSchema() const override;
	virtual FBlueprintActionResult Execute(const TSharedPtr<FJsonObject>& Params) override;
};
