// Copyright (c) 2026 CelestiaDominance. All Rights Reserved.

#pragma once

#include "Actions/IBlueprintAction.h"

/**
 * Action: remove_memory
 * Removes a persistent memory entry by its ID.
 */
class FRemoveMemoryAction : public IBlueprintAction
{
public:
	virtual FString GetName() const override { return TEXT("remove_memory"); }

	virtual FString GetDescription() const override
	{
		return TEXT("Remove a persistent memory by its ID (e.g. 'M1'). "
			"Use this to delete outdated or incorrect memories.");
	}

	virtual TSharedPtr<FJsonObject> GetParameterSchema() const override;
	virtual FBlueprintActionResult Execute(const TSharedPtr<FJsonObject>& Params) override;
};
