// Copyright (c) 2026 CelestiaDominance. All Rights Reserved.

#pragma once

#include "Actions/IBlueprintAction.h"

/**
 * Action: remove_component
 * Removes a component from a Blueprint's component hierarchy.
 */
class FRemoveComponentAction : public IBlueprintAction
{
public:
	virtual FString GetName() const override { return TEXT("remove_component"); }

	virtual FString GetDescription() const override
	{
		return TEXT("Removes a component from a Blueprint's component hierarchy by its variable name "
			"(as returned by add_component). Children of the removed component are reparented to its parent.");
	}

	virtual TSharedPtr<FJsonObject> GetParameterSchema() const override;
	virtual FBlueprintActionResult Execute(const TSharedPtr<FJsonObject>& Params) override;
};
