// Copyright (c) 2026 CelestiaDominance. All Rights Reserved.

#pragma once

#include "Actions/IBlueprintAction.h"

/**
 * Action: open_blueprint
 * Opens a Blueprint asset in the Blueprint Editor.
 */
class FOpenBlueprintAction : public IBlueprintAction
{
public:
	virtual FString GetName() const override { return TEXT("open_blueprint"); }

	virtual FString GetDescription() const override
	{
		return TEXT("Opens a Blueprint in the Blueprint Editor window. "
			"Use this after creating or modifying a Blueprint so the user can see it.");
	}

	virtual TSharedPtr<FJsonObject> GetParameterSchema() const override;
	virtual FBlueprintActionResult Execute(const TSharedPtr<FJsonObject>& Params) override;
};
