// Copyright (c) 2026 CelestiaDominance. All Rights Reserved.

#pragma once

#include "Actions/IBlueprintAction.h"

/**
 * Action: list_assets
 * Lists project assets, optionally filtering by type and path.
 */
class FListAssetsAction : public IBlueprintAction
{
public:
	virtual FString GetName() const override { return TEXT("list_assets"); }

	virtual FString GetDescription() const override
	{
		return TEXT("Lists assets in the project content directory. "
			"Can filter by type (Blueprint, Material, Texture, StaticMesh, SkeletalMesh, etc.) "
			"and by content path (e.g. '/Game/Blueprints'). "
			"Useful for finding existing Blueprints or resources to reference.");
	}

	virtual TSharedPtr<FJsonObject> GetParameterSchema() const override;
	virtual FBlueprintActionResult Execute(const TSharedPtr<FJsonObject>& Params) override;
};
