// Copyright (c) 2026 CelestiaDominance. All Rights Reserved.

#pragma once

#include "Actions/IBlueprintAction.h"

class FActionRegistry;

/**
 * Action: get_selected_nodes
 * Returns the nodes currently selected by the user in the Blueprint graph editor.
 * Tracks each selected node so the AI can reference them by node_id.
 */
class FGetSelectedNodesAction : public IBlueprintAction
{
public:
	FGetSelectedNodesAction(FActionRegistry* InRegistry) : Registry(InRegistry) {}

	virtual FString GetName() const override { return TEXT("get_selected_nodes"); }

	virtual FString GetDescription() const override
	{
		return TEXT("Returns the nodes currently selected by the user in the Blueprint graph editor. "
			"Each node is tracked with a node_id so you can reference it in connect_nodes, delete_node, etc. "
			"Use this when the user mentions 'selected nodes' or 'these nodes'. "
			"No parameters required.");
	}

	virtual TSharedPtr<FJsonObject> GetParameterSchema() const override;
	virtual FBlueprintActionResult Execute(const TSharedPtr<FJsonObject>& Params) override;

private:
	FActionRegistry* Registry = nullptr;
};
