// Copyright (c) 2026 CelestiaDominance. All Rights Reserved.

#pragma once

#include "Actions/IBlueprintAction.h"

/**
 * Action: get_project_structure
 * Returns the project content folder structure and asset type counts.
 * Gives the AI an overview of the entire project without needing to list every asset.
 */
class FGetProjectStructureAction : public IBlueprintAction
{
public:
	virtual FString GetName() const override { return TEXT("get_project_structure"); }

	virtual FString GetDescription() const override
	{
		return TEXT("Returns the project content folder structure and asset counts by type. "
			"Use this to understand the project layout, find where assets are located, "
			"and see what types of assets exist.");
	}

	virtual TSharedPtr<FJsonObject> GetParameterSchema() const override;
	virtual FBlueprintActionResult Execute(const TSharedPtr<FJsonObject>& Params) override;
};
