// Copyright (c) 2026 CelestiaDominance. All Rights Reserved.

#pragma once

#include "Actions/IBlueprintAction.h"

/**
 * Action: get_open_blueprint
 * Returns the Blueprint(s) currently open in the Blueprint Editor.
 * Lets the AI detect what the user is working on without being told.
 */
class FGetOpenBlueprintAction : public IBlueprintAction
{
public:
	virtual FString GetName() const override { return TEXT("get_open_blueprint"); }

	virtual FString GetDescription() const override
	{
		return TEXT("Returns all Blueprints currently open in the editor. "
			"Use this to discover what the user is working on. "
			"No parameters required.");
	}

	virtual TSharedPtr<FJsonObject> GetParameterSchema() const override;
	virtual FBlueprintActionResult Execute(const TSharedPtr<FJsonObject>& Params) override;
};
