// Copyright (c) 2026 CelestiaDominance. All Rights Reserved.

#pragma once

#include "Actions/IBlueprintAction.h"

/**
 * Action: get_component_properties
 * Targeted query: returns properties of a specific component, optionally filtered by name.
 * Much more efficient than calling get_blueprint_info when you only need to check
 * or find specific properties on a component (e.g., JumpZVelocity on CharacterMovement).
 */
class FGetComponentPropertiesAction : public IBlueprintAction
{
public:
	virtual FString GetName() const override { return TEXT("get_component_properties"); }

	virtual FString GetDescription() const override
	{
		return TEXT("Get properties of a specific component in a Blueprint, optionally filtered by name. "
			"Returns property names, types, and current values. Use this to discover available properties "
			"before calling set_component_property. Works with both Blueprint-added and inherited components "
			"(e.g., CharacterMovement, CapsuleComponent, Mesh). "
			"Example: get_component_properties('BP_ThirdPersonCharacter', 'CharacterMovement', 'Jump') "
			"returns all properties containing 'Jump' in their name.");
	}

	virtual TSharedPtr<FJsonObject> GetParameterSchema() const override;
	virtual FBlueprintActionResult Execute(const TSharedPtr<FJsonObject>& Params) override;
};
