// Copyright (c) 2026 CelestiaDominance. All Rights Reserved.

#pragma once

#include "Actions/IBlueprintAction.h"

/**
 * Action: get_class_functions
 * Lists callable functions on a UClass so the AI can discover valid function_name/function_class
 * values instead of guessing.
 */
class FGetClassFunctionsAction : public IBlueprintAction
{
public:
	virtual FString GetName() const override { return TEXT("get_class_functions"); }

	virtual FString GetDescription() const override
	{
		return TEXT("Lists Blueprint-callable functions on a class (e.g. 'Actor', 'StaticMeshComponent', 'KismetMathLibrary'). "
			"Returns function names and their parameters so you can use them with add_node's CallFunction node_type. "
			"Use name_filter to search for specific functions (e.g. 'Rotate', 'Location', 'Spawn').");
	}

	virtual TSharedPtr<FJsonObject> GetParameterSchema() const override;
	virtual FBlueprintActionResult Execute(const TSharedPtr<FJsonObject>& Params) override;
};
