// Copyright (c) 2026 CelestiaDominance. All Rights Reserved.

#pragma once

#include "Actions/IBlueprintAction.h"

class FActionRegistry;

/**
 * Action: get_blueprint_info
 * Reads and returns information about an existing Blueprint's structure:
 * variables, functions, graphs, nodes, and connections.
 */
class FGetBlueprintInfoAction : public IBlueprintAction
{
public:
	FGetBlueprintInfoAction(FActionRegistry* InRegistry) : Registry(InRegistry) {}

	virtual FString GetName() const override { return TEXT("get_blueprint_info"); }

	virtual FString GetDescription() const override
	{
		return TEXT("Returns detailed information about a Blueprint: its parent class, variables, functions, graphs, "
			"and optionally the nodes and connections in a specific graph. "
			"Use this to understand existing Blueprints before modifying them.");
	}

	virtual TSharedPtr<FJsonObject> GetParameterSchema() const override;
	virtual FBlueprintActionResult Execute(const TSharedPtr<FJsonObject>& Params) override;

private:
	FActionRegistry* Registry = nullptr;
};
