// Copyright (c) 2026 CelestiaDominance. All Rights Reserved.

#pragma once

#include "Actions/IBlueprintAction.h"

class FActionRegistry;

/**
 * Action: disconnect_nodes
 * Breaks a connection between two node pins without deleting either node.
 */
class FDisconnectNodesAction : public IBlueprintAction
{
public:
	FDisconnectNodesAction(FActionRegistry* InRegistry) : Registry(InRegistry) {}

	virtual FString GetName() const override { return TEXT("disconnect_nodes"); }

	virtual FString GetDescription() const override
	{
		return TEXT("Breaks a connection between two node pins. "
			"Specify the source output pin and target input pin to disconnect. "
			"Does not delete either node — only removes the wire between them.");
	}

	virtual TSharedPtr<FJsonObject> GetParameterSchema() const override;
	virtual FBlueprintActionResult Execute(const TSharedPtr<FJsonObject>& Params) override;

private:
	FActionRegistry* Registry = nullptr;
};
