// Copyright (c) 2026 CelestiaDominance. All Rights Reserved.

#pragma once

#include "Actions/IBlueprintAction.h"

class FActionRegistry;

/**
 * Action: delete_node
 * Removes a tracked node from a Blueprint graph.
 */
class FDeleteNodeAction : public IBlueprintAction
{
public:
	FDeleteNodeAction(FActionRegistry* InRegistry) : Registry(InRegistry) {}

	virtual FString GetName() const override { return TEXT("delete_node"); }

	virtual FString GetDescription() const override
	{
		return TEXT("Deletes a node from a Blueprint graph by its tracked node_id (e.g. 'N1'). "
			"The node and all its connections are removed.");
	}

	virtual TSharedPtr<FJsonObject> GetParameterSchema() const override;
	virtual FBlueprintActionResult Execute(const TSharedPtr<FJsonObject>& Params) override;

private:
	FActionRegistry* Registry = nullptr;
};
