// Copyright (c) 2026 CelestiaDominance. All Rights Reserved.

#pragma once

#include "Actions/IBlueprintAction.h"

class FActionRegistry;

/**
 * Action: create_blueprint
 * Creates a new Blueprint asset in the content browser.
 */
class FCreateBlueprintAction : public IBlueprintAction
{
public:
	FCreateBlueprintAction(FActionRegistry* InRegistry) : Registry(InRegistry) {}

	virtual FString GetName() const override { return TEXT("create_blueprint"); }

	virtual FString GetDescription() const override
	{
		return TEXT("Creates a new Blueprint class asset. Returns the full content path of the created Blueprint. "
			"Use parent_class to specify the base class (e.g. 'Actor', 'Pawn', 'Character', 'ActorComponent', 'GameModeBase', 'PlayerController', 'HUD'). "
			"The Blueprint is created with a default EventGraph.");
	}

	virtual TSharedPtr<FJsonObject> GetParameterSchema() const override;
	virtual FBlueprintActionResult Execute(const TSharedPtr<FJsonObject>& Params) override;

private:
	/** Resolve a short class name like "Actor" to a UClass* */
	static UClass* ResolveParentClass(const FString& ClassName);

	FActionRegistry* Registry = nullptr;
};
