// Copyright (c) 2026 CelestiaDominance. All Rights Reserved.

#pragma once

#include "Actions/IBlueprintAction.h"

class FActionRegistry;

/**
 * Action: connect_nodes
 * Connects two pins between nodes in a Blueprint graph.
 * Uses node tracking IDs from add_node results.
 */
class FConnectNodesAction : public IBlueprintAction
{
public:
	FConnectNodesAction(FActionRegistry* InRegistry) : Registry(InRegistry) {}

	virtual FString GetName() const override { return TEXT("connect_nodes"); }

	virtual FString GetDescription() const override
	{
		return TEXT("Connects an output pin of one node to an input pin of another node. "
			"Use node_id values returned by add_node. "
			"Pin names are exact (case-sensitive) as returned in the 'pins' array from add_node. "
			"Execution flow: connect source exec output (e.g. 'then') to target exec input (e.g. 'execute'). "
			"Data flow: connect source data output (e.g. 'ReturnValue') to target data input (e.g. 'InString').");
	}

	virtual TSharedPtr<FJsonObject> GetParameterSchema() const override;
	virtual FBlueprintActionResult Execute(const TSharedPtr<FJsonObject>& Params) override;

private:
	FActionRegistry* Registry = nullptr;
};
